/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.BasicRejectBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class BasicRejectBodyImpl
extends AMQMethodBody_0_9
implements BasicRejectBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new BasicRejectBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 90;
    private final long _deliveryTag;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public BasicRejectBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._deliveryTag = this.readLong(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public BasicRejectBodyImpl(long deliveryTag, boolean requeue) {
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (requeue) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    public int getClazz() {
        return 60;
    }

    public int getMethod() {
        return 90;
    }

    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    public final boolean getRequeue() {
        return (this._bitfield0 & 1) != 0;
    }

    protected int getBodySize() {
        int size = 9;
        return size;
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchBasicReject(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicRejectBodyImpl: ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("requeue=");
        buf.append(this.getRequeue());
        buf.append("]");
        return buf.toString();
    }
}

