/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FileReturnBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class FileReturnBodyImpl
extends AMQMethodBody_8_0
implements FileReturnBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new FileReturnBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 70;
    public static final int METHOD_ID = 70;
    private final int _replyCode;
    private final AMQShortString _replyText;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public FileReturnBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._replyCode = this.readUnsignedShort(buffer);
        this._replyText = this.readAMQShortString(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
    }

    public FileReturnBodyImpl(int replyCode, AMQShortString replyText, AMQShortString exchange, AMQShortString routingKey) {
        this._replyCode = replyCode;
        this._replyText = replyText;
        this._exchange = exchange;
        this._routingKey = routingKey;
    }

    public int getClazz() {
        return 70;
    }

    public int getMethod() {
        return 70;
    }

    public final int getReplyCode() {
        return this._replyCode;
    }

    public final AMQShortString getReplyText() {
        return this._replyText;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    protected int getBodySize() {
        int size = 2;
        size += this.getSizeOf(this._replyText);
        size += this.getSizeOf(this._exchange);
        return size += this.getSizeOf(this._routingKey);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._replyCode);
        this.writeAMQShortString(buffer, this._replyText);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchFileReturn(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[FileReturnBodyImpl: ");
        buf.append("replyCode=");
        buf.append(this.getReplyCode());
        buf.append(", ");
        buf.append("replyText=");
        buf.append(this.getReplyText());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append("]");
        return buf.toString();
    }
}

