/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.nio.ByteBuffer;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.ProtocolEvent;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.Assembler;
import org.apache.qpid.transport.network.Disassembler;
import org.apache.qpid.transport.network.InputHandler;
import org.apache.qpid.transport.network.NetworkTransport;
import org.apache.qpid.transport.network.Transport;
import org.apache.qpid.transport.network.security.SecurityLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportBuilder {
    private Connection con;
    private ConnectionSettings settings;
    private NetworkTransport transport;
    private SecurityLayer securityLayer = new SecurityLayer();

    public void init(Connection con) throws TransportException {
        this.con = con;
        this.settings = con.getConnectionSettings();
        this.transport = Transport.getTransport();
        this.transport.init(this.settings);
        this.securityLayer.init(con);
    }

    public Sender<ProtocolEvent> buildSenderPipe() {
        ConnectionSettings settings = this.con.getConnectionSettings();
        Sender<ByteBuffer> sender = this.transport.sender();
        sender = this.securityLayer.sender(sender);
        Disassembler dis = new Disassembler(sender, settings.getMaxFrameSize());
        return dis;
    }

    public void buildReceiverPipe(Receiver<ProtocolEvent> delegate) {
        Receiver<ByteBuffer> receiver = new InputHandler(new Assembler(delegate));
        receiver = this.securityLayer.receiver(receiver);
        this.transport.receiver(receiver);
    }

    public SecurityLayer getSecurityLayer() {
        return this.securityLayer;
    }
}

