/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.ssl.SSLContextFactory;
import org.apache.qpid.transport.Binding;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.ConnectionBinding;
import org.apache.qpid.transport.network.io.InputHandler_0_9;
import org.apache.qpid.transport.network.io.IoContext;
import org.apache.qpid.transport.network.io.IoReceiver;
import org.apache.qpid.transport.network.io.IoSender;
import org.apache.qpid.transport.network.security.ssl.SSLReceiver;
import org.apache.qpid.transport.network.security.ssl.SSLSender;
import org.apache.qpid.transport.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IoTransport<E>
implements IoContext {
    private static final Logger log;
    private static int DEFAULT_READ_WRITE_BUFFER_SIZE;
    private static int readBufferSize;
    private static int writeBufferSize;
    private Socket socket;
    private Sender<java.nio.ByteBuffer> sender;
    private E endpoint;
    private IoReceiver receiver;
    private long timeout = 60000L;

    IoTransport(Socket socket, Binding<E, java.nio.ByteBuffer> binding, boolean ssl) {
        this.socket = socket;
        if (ssl) {
            SSLContext sslCtx;
            SSLEngine engine = null;
            try {
                sslCtx = this.createSSLContext();
            }
            catch (Exception e) {
                throw new TransportException("Error creating SSL Context", e);
            }
            try {
                engine = sslCtx.createSSLEngine();
                engine.setUseClientMode(true);
            }
            catch (Exception e) {
                throw new TransportException("Error creating SSL Engine", e);
            }
            this.sender = new SSLSender(engine, new IoSender(this, 2 * writeBufferSize, this.timeout));
            this.endpoint = binding.endpoint(this.sender);
            this.receiver = new IoReceiver(this, new SSLReceiver(engine, binding.receiver(this.endpoint), (SSLSender)this.sender), 2 * readBufferSize, this.timeout);
            log.info("SSL Sender and Receiver initiated", new Object[0]);
        } else {
            this.sender = new IoSender(this, 2 * writeBufferSize, this.timeout);
            this.endpoint = binding.endpoint(this.sender);
            this.receiver = new IoReceiver(this, binding.receiver(this.endpoint), 2 * readBufferSize, this.timeout);
        }
    }

    @Override
    public Sender<java.nio.ByteBuffer> getSender() {
        return this.sender;
    }

    @Override
    public IoReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    public static final <E> E connect(String host, int port, Binding<E, java.nio.ByteBuffer> binding, boolean ssl) {
        Socket socket = IoTransport.createSocket(host, port);
        IoTransport<E> transport = new IoTransport<E>(socket, binding, ssl);
        return transport.endpoint;
    }

    public static final Connection connect(String host, int port, ConnectionDelegate delegate, boolean ssl) {
        return IoTransport.connect(host, port, ConnectionBinding.get(delegate), ssl);
    }

    public static void connect_0_9(AMQVersionAwareProtocolSession session, String host, int port, boolean ssl) {
        IoTransport.connect(host, port, new Binding_0_9(session), ssl);
    }

    private static Socket createSocket(String host, int port) {
        try {
            InetAddress address = InetAddress.getByName(host);
            Socket socket = new Socket();
            socket.setReuseAddress(true);
            socket.setTcpNoDelay(Boolean.getBoolean("amqj.tcpNoDelay"));
            log.debug("default-SO_RCVBUF : %s", socket.getReceiveBufferSize());
            log.debug("default-SO_SNDBUF : %s", socket.getSendBufferSize());
            socket.setSendBufferSize(writeBufferSize);
            socket.setReceiveBufferSize(readBufferSize);
            log.debug("new-SO_RCVBUF : %s", socket.getReceiveBufferSize());
            log.debug("new-SO_SNDBUF : %s", socket.getSendBufferSize());
            socket.connect(new InetSocketAddress(address, port));
            return socket;
        }
        catch (SocketException e) {
            throw new TransportException("Error connecting to broker", e);
        }
        catch (IOException e) {
            throw new TransportException("Error connecting to broker", e);
        }
    }

    private SSLContext createSSLContext() throws Exception {
        String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        String trustStoreCertType = System.getProperty("qpid.ssl.trustStoreCertType", "SunX509");
        String keyStorePath = System.getProperty("javax.net.ssl.keyStore", trustStorePath);
        String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", trustStorePassword);
        String keyStoreCertType = System.getProperty("qpid.ssl.keyStoreCertType", "SunX509");
        SSLContextFactory sslContextFactory = new SSLContextFactory(trustStorePath, trustStorePassword, trustStoreCertType, keyStorePath, keyStorePassword, keyStoreCertType);
        return sslContextFactory.buildServerContext();
    }

    static {
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        ByteBuffer.setUseDirectBuffers((boolean)Boolean.getBoolean("amqj.enableDirectBuffers"));
        log = Logger.get(IoTransport.class);
        DEFAULT_READ_WRITE_BUFFER_SIZE = 65536;
        readBufferSize = Integer.getInteger("amqj.receiveBufferSize", DEFAULT_READ_WRITE_BUFFER_SIZE);
        writeBufferSize = Integer.getInteger("amqj.sendBufferSize", DEFAULT_READ_WRITE_BUFFER_SIZE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Binding_0_9
    implements Binding<AMQVersionAwareProtocolSession, java.nio.ByteBuffer> {
        private AMQVersionAwareProtocolSession session;

        Binding_0_9(AMQVersionAwareProtocolSession session) {
            this.session = session;
        }

        @Override
        public AMQVersionAwareProtocolSession endpoint(Sender<java.nio.ByteBuffer> sender) {
            this.session.setSender(sender);
            return this.session;
        }

        @Override
        public Receiver<java.nio.ByteBuffer> receiver(AMQVersionAwareProtocolSession ssn) {
            return new InputHandler_0_9(ssn);
        }
    }
}

