/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.nio;

import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.qpid.transport.Sender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioSender
implements Sender<ByteBuffer> {
    private final Object lock = new Object();
    private SocketChannel _ch;
    private boolean _batch = false;
    private ByteBuffer _batcher;

    public NioSender(SocketChannel ch) {
        this._ch = ch;
    }

    @Override
    public void send(ByteBuffer buf) {
        if (this._batch) {
            if (this._batcher.position() + buf.remaining() >= this._batcher.capacity()) {
                this._batcher.flip();
                this.write(this._batcher);
                this._batcher.clear();
                if (buf.remaining() > this._batcher.capacity()) {
                    this.write(buf);
                } else {
                    this._batcher.put(buf);
                }
            } else {
                this._batcher.put(buf);
            }
        } else {
            this.write(buf);
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(ByteBuffer buf) {
        Object object = this.lock;
        synchronized (object) {
            if (this._ch.isConnected() && this._ch.isOpen()) {
                try {
                    this._ch.write(buf);
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
            } else {
                throw new RuntimeException("Trying to write on a closed socket");
            }
        }
    }

    public void setStartBatching() {
        this._batch = true;
        this._batcher = ByteBuffer.allocate(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this._ch.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setIdleTimeout(int i) {
    }
}

