/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MessageRejectBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class MessageRejectBodyImpl
extends AMQMethodBody_0_9
implements MessageRejectBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new MessageRejectBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 520;
    private final int _code;
    private final AMQShortString _text;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public MessageRejectBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._code = this.readUnsignedShort(buffer);
        this._text = this.readAMQShortString(buffer);
    }

    public MessageRejectBodyImpl(int code, AMQShortString text) {
        this._code = code;
        this._text = text;
    }

    public int getClazz() {
        return 120;
    }

    public int getMethod() {
        return 520;
    }

    public final int getCode() {
        return this._code;
    }

    public final AMQShortString getText() {
        return this._text;
    }

    protected int getBodySize() {
        int size = 2;
        return size += this.getSizeOf(this._text);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._code);
        this.writeAMQShortString(buffer, this._text);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchMessageReject(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[MessageRejectBodyImpl: ");
        buf.append("code=");
        buf.append(this.getCode());
        buf.append(", ");
        buf.append("text=");
        buf.append(this.getText());
        buf.append("]");
        return buf.toString();
    }
}

