/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MessageResumeBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class MessageResumeBodyImpl
extends AMQMethodBody_0_9
implements MessageResumeBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new MessageResumeBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 100;
    private final byte[] _reference;
    private final AMQShortString _identifier;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public MessageResumeBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._reference = this.readBytes(buffer);
        this._identifier = this.readAMQShortString(buffer);
    }

    public MessageResumeBodyImpl(byte[] reference, AMQShortString identifier) {
        this._reference = reference;
        this._identifier = identifier;
    }

    public int getClazz() {
        return 120;
    }

    public int getMethod() {
        return 100;
    }

    public final byte[] getReference() {
        return this._reference;
    }

    public final AMQShortString getIdentifier() {
        return this._identifier;
    }

    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._reference);
        return size += this.getSizeOf(this._identifier);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeBytes(buffer, this._reference);
        this.writeAMQShortString(buffer, this._identifier);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchMessageResume(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[MessageResumeBodyImpl: ");
        buf.append("reference=");
        buf.append(this.getReference() == null ? "null" : Arrays.toString(this.getReference()));
        buf.append(", ");
        buf.append("identifier=");
        buf.append(this.getIdentifier());
        buf.append("]");
        return buf.toString();
    }
}

