/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Acquired
extends Struct {
    public static final int TYPE = 1028;
    private short packing_flags = 0;
    private RangeSet transfers;

    @Override
    public final int getStructType() {
        return 1028;
    }

    @Override
    public final int getSizeWidth() {
        return 4;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    public final boolean hasPayload() {
        return false;
    }

    public final byte getEncodedTrack() {
        return -1;
    }

    public final boolean isConnectionControl() {
        return false;
    }

    public Acquired() {
    }

    public Acquired(RangeSet transfers) {
        if (transfers != null) {
            this.setTransfers(transfers);
        }
    }

    public final boolean hasTransfers() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final Acquired clearTransfers() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.transfers = null;
        this.setDirty(true);
        return this;
    }

    public final RangeSet getTransfers() {
        return this.transfers;
    }

    public final Acquired setTransfers(RangeSet value) {
        this.transfers = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final Acquired transfers(RangeSet value) {
        return this.setTransfers(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeSequenceSet(this.transfers);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.transfers = dec.readSequenceSet();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("transfers", this.getTransfers());
        }
        return result;
    }
}

