/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.ConnectionOpen;
import org.apache.qpid.transport.ConnectionSecureOk;
import org.apache.qpid.transport.ConnectionStartOk;
import org.apache.qpid.transport.ConnectionTuneOk;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionAttach;
import org.apache.qpid.transport.SessionDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerDelegate
extends ConnectionDelegate {
    protected static final Logger _logger = LoggerFactory.getLogger(ServerDelegate.class);
    private List<Object> _locales;
    private List<Object> _mechanisms;
    private Map<String, Object> _clientProperties;

    public ServerDelegate() {
        this(null, Collections.emptyList(), Collections.singletonList("utf8"));
    }

    protected ServerDelegate(Map<String, Object> clientProperties, List<Object> mechanisms, List<Object> locales) {
        this._clientProperties = clientProperties;
        this._mechanisms = mechanisms;
        this._locales = locales;
    }

    @Override
    public void init(Connection conn, ProtocolHeader hdr) {
        conn.send(new ProtocolHeader(1, 0, 10));
        conn.connectionStart(this._clientProperties, this._mechanisms, this._locales, new Option[0]);
    }

    @Override
    public void connectionStartOk(Connection conn, ConnectionStartOk ok) {
        conn.setLocale(ok.getLocale());
        String mechanism = ok.getMechanism();
        if (mechanism == null || mechanism.length() == 0) {
            this.tuneAuthorizedConnection(conn);
            return;
        }
        try {
            SaslServer ss = this.createSaslServer(conn, mechanism);
            if (ss == null) {
                conn.connectionClose(ConnectionCloseCode.CONNECTION_FORCED, "null SASL mechanism: " + mechanism, new Option[0]);
                return;
            }
            conn.setSaslServer(ss);
            this.secure(conn, ok.getResponse());
        }
        catch (SaslException e) {
            this.connectionAuthFailed(conn, e);
        }
    }

    protected SaslServer createSaslServer(Connection conn, String mechanism) throws SaslException {
        SaslServer ss = Sasl.createSaslServer(mechanism, "AMQP", "localhost", null, null);
        return ss;
    }

    protected void secure(SaslServer ss, Connection conn, byte[] response) {
        try {
            byte[] challenge = ss.evaluateResponse(response);
            if (ss.isComplete()) {
                ss.dispose();
                this.tuneAuthorizedConnection(conn);
            } else {
                this.connectionAuthContinue(conn, challenge);
            }
        }
        catch (SaslException e) {
            this.connectionAuthFailed(conn, e);
        }
    }

    protected void connectionAuthFailed(Connection conn, Exception e) {
        conn.exception(e);
        conn.connectionClose(ConnectionCloseCode.CONNECTION_FORCED, e.getMessage(), new Option[0]);
    }

    protected void connectionAuthContinue(Connection conn, byte[] challenge) {
        conn.connectionSecure(challenge, new Option[0]);
    }

    protected void tuneAuthorizedConnection(Connection conn) {
        conn.connectionTune(this.getChannelMax(), 65535, 0, this.getHeartbeatMax(), new Option[0]);
    }

    protected void secure(Connection conn, byte[] response) {
        SaslServer ss = conn.getSaslServer();
        this.secure(ss, conn, response);
    }

    protected int getHeartbeatMax() {
        return 65535;
    }

    protected int getChannelMax() {
        return 65535;
    }

    @Override
    public void connectionSecureOk(Connection conn, ConnectionSecureOk ok) {
        this.secure(conn, ok.getResponse());
    }

    @Override
    public void connectionTuneOk(Connection conn, ConnectionTuneOk ok) {
    }

    @Override
    public void connectionOpen(Connection conn, ConnectionOpen open) {
        conn.connectionOpenOk(Collections.<Object>emptyList(), new Option[0]);
        conn.setState(Connection.State.OPEN);
    }

    protected Session getSession(Connection conn, SessionDelegate delegate, SessionAttach atc) {
        return new Session(conn, delegate, new Binary(atc.getName()), 0L);
    }

    public Session getSession(Connection conn, SessionAttach atc) {
        return new Session(conn, new Binary(atc.getName()), 0L);
    }

    @Override
    public void sessionAttach(Connection conn, SessionAttach atc) {
        Session ssn = this.getSession(conn, atc);
        conn.map(ssn, atc.getChannel());
        conn.registerSession(ssn);
        ssn.sessionAttached(atc.getName(), new Option[0]);
        ssn.setState(Session.State.OPEN);
    }

    protected void setConnectionTuneOkChannelMax(Connection conn, int okChannelMax) {
        conn.setChannelMax(okChannelMax == 0 ? 65535 : okChannelMax);
    }
}

