/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Type {
    BIN8(0, 1, true),
    INT8(1, 1, true),
    UINT8(2, 1, true),
    CHAR(4, 1, true),
    BOOLEAN(8, 1, true),
    BIN16(16, 2, true),
    INT16(17, 2, true),
    UINT16(18, 2, true),
    BIN32(32, 4, true),
    INT32(33, 4, true),
    UINT32(34, 4, true),
    FLOAT(35, 4, true),
    CHAR_UTF32(39, 4, true),
    BIN64(48, 8, true),
    INT64(49, 8, true),
    UINT64(50, 8, true),
    DOUBLE(51, 8, true),
    DATETIME(56, 8, true),
    BIN128(64, 16, true),
    UUID(72, 16, true),
    BIN256(80, 32, true),
    BIN512(96, 64, true),
    BIN1024(112, 128, true),
    VBIN8(-128, 1, false),
    STR8_LATIN(-124, 1, false),
    STR8(-123, 1, false),
    STR8_UTF16(-122, 1, false),
    VBIN16(-112, 2, false),
    STR16_LATIN(-108, 2, false),
    STR16(-107, 2, false),
    STR16_UTF16(-106, 2, false),
    VBIN32(-96, 4, false),
    MAP(-88, 4, false),
    LIST(-87, 4, false),
    ARRAY(-86, 4, false),
    STRUCT32(-85, 4, false),
    BIN40(-64, 5, true),
    DEC32(-56, 5, true),
    BIN72(-48, 9, true),
    DEC64(-40, 9, true),
    VOID(-16, 0, true),
    BIT(-15, 0, true);

    private final byte code;
    private final int width;
    private final boolean fixed;

    private Type(byte code, int width, boolean fixed) {
        this.code = code;
        this.width = width;
        this.fixed = fixed;
    }

    public byte getCode() {
        return this.code;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public static Type get(byte code) {
        switch (code) {
            case 0: {
                return BIN8;
            }
            case 1: {
                return INT8;
            }
            case 2: {
                return UINT8;
            }
            case 4: {
                return CHAR;
            }
            case 8: {
                return BOOLEAN;
            }
            case 16: {
                return BIN16;
            }
            case 17: {
                return INT16;
            }
            case 18: {
                return UINT16;
            }
            case 32: {
                return BIN32;
            }
            case 33: {
                return INT32;
            }
            case 34: {
                return UINT32;
            }
            case 35: {
                return FLOAT;
            }
            case 39: {
                return CHAR_UTF32;
            }
            case 48: {
                return BIN64;
            }
            case 49: {
                return INT64;
            }
            case 50: {
                return UINT64;
            }
            case 51: {
                return DOUBLE;
            }
            case 56: {
                return DATETIME;
            }
            case 64: {
                return BIN128;
            }
            case 72: {
                return UUID;
            }
            case 80: {
                return BIN256;
            }
            case 96: {
                return BIN512;
            }
            case 112: {
                return BIN1024;
            }
            case -128: {
                return VBIN8;
            }
            case -124: {
                return STR8_LATIN;
            }
            case -123: {
                return STR8;
            }
            case -122: {
                return STR8_UTF16;
            }
            case -112: {
                return VBIN16;
            }
            case -108: {
                return STR16_LATIN;
            }
            case -107: {
                return STR16;
            }
            case -106: {
                return STR16_UTF16;
            }
            case -96: {
                return VBIN32;
            }
            case -88: {
                return MAP;
            }
            case -87: {
                return LIST;
            }
            case -86: {
                return ARRAY;
            }
            case -85: {
                return STRUCT32;
            }
            case -64: {
                return BIN40;
            }
            case -56: {
                return DEC32;
            }
            case -48: {
                return BIN72;
            }
            case -40: {
                return DEC64;
            }
            case -16: {
                return VOID;
            }
            case -15: {
                return BIT;
            }
        }
        return null;
    }
}

