/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/*
 * This file is auto-generated by Qpid Gentools v.0.1 - do not modify.
 * Supported AMQP version:
  *   0-9
  *   0-91
  *   8-0
  */
 
package org.apache.qpid.framing;

import java.io.IOException;

import org.apache.qpid.framing.abstraction.ProtocolVersionMethodConverter;
import org.apache.qpid.codec.MarkableDataInput;

import java.util.Map;
import java.util.HashMap;


public abstract class MethodRegistry
{
    private static final Map<ProtocolVersion, MethodRegistry> _registries =
            new HashMap<ProtocolVersion, MethodRegistry>();


	public static final MethodRegistry registry_0_9 = 
	    new org.apache.qpid.framing.amqp_0_9.MethodRegistry_0_9();
	

	public static final MethodRegistry registry_0_91 = 
	    new org.apache.qpid.framing.amqp_0_91.MethodRegistry_0_91();
	

	public static final MethodRegistry registry_8_0 = 
	    new org.apache.qpid.framing.amqp_8_0.MethodRegistry_8_0();
	
 			
			
    public abstract AMQMethodBody convertToBody(MarkableDataInput in, long size)
        throws AMQFrameDecodingException, IOException;

    public abstract int getMaxClassId();

    public abstract int getMaxMethodId(int classId);

    
    protected MethodRegistry(ProtocolVersion pv)
    {
        _registries.put(pv, this);
    }

    public static MethodRegistry getMethodRegistry(ProtocolVersion pv)
    {
        return _registries.get(pv);
    }




    public abstract BasicAckBody createBasicAckBody(	
                                final long deliveryTag,
                                final boolean multiple
	                        );



    public abstract BasicCancelBody createBasicCancelBody(	
                                final AMQShortString consumerTag,
                                final boolean nowait
	                        );



    public abstract BasicCancelOkBody createBasicCancelOkBody(	
                                final AMQShortString consumerTag
	                        );



    public abstract BasicConsumeBody createBasicConsumeBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final AMQShortString consumerTag,
                                final boolean noLocal,
                                final boolean noAck,
                                final boolean exclusive,
                                final boolean nowait,
                                final FieldTable arguments
	                        );



    public abstract BasicConsumeOkBody createBasicConsumeOkBody(	
                                final AMQShortString consumerTag
	                        );



    public abstract BasicDeliverBody createBasicDeliverBody(	
                                final AMQShortString consumerTag,
                                final long deliveryTag,
                                final boolean redelivered,
                                final AMQShortString exchange,
                                final AMQShortString routingKey
	                        );



    public abstract BasicGetBody createBasicGetBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final boolean noAck
	                        );



    public abstract BasicGetEmptyBody createBasicGetEmptyBody(	
                                final AMQShortString clusterId
	                        );



    public abstract BasicGetOkBody createBasicGetOkBody(	
                                final long deliveryTag,
                                final boolean redelivered,
                                final AMQShortString exchange,
                                final AMQShortString routingKey,
                                final long messageCount
	                        );



    public abstract BasicPublishBody createBasicPublishBody(	
                                final int ticket,
                                final AMQShortString exchange,
                                final AMQShortString routingKey,
                                final boolean mandatory,
                                final boolean immediate
	                        );



    public abstract BasicQosBody createBasicQosBody(	
                                final long prefetchSize,
                                final int prefetchCount,
                                final boolean global
	                        );



    public abstract BasicQosOkBody createBasicQosOkBody(	
	                        );



    public abstract BasicRecoverBody createBasicRecoverBody(	
                                final boolean requeue
	                        );



    public abstract BasicRejectBody createBasicRejectBody(	
                                final long deliveryTag,
                                final boolean requeue
	                        );



    public abstract BasicReturnBody createBasicReturnBody(	
                                final int replyCode,
                                final AMQShortString replyText,
                                final AMQShortString exchange,
                                final AMQShortString routingKey
	                        );




    public abstract ChannelCloseBody createChannelCloseBody(	
                                final int replyCode,
                                final AMQShortString replyText,
                                final int classId,
                                final int methodId
	                        );



    public abstract ChannelCloseOkBody createChannelCloseOkBody(	
	                        );



    public abstract ChannelFlowBody createChannelFlowBody(	
                                final boolean active
	                        );



    public abstract ChannelFlowOkBody createChannelFlowOkBody(	
                                final boolean active
	                        );



    public abstract ChannelOpenBody createChannelOpenBody(	
                                final AMQShortString outOfBand
	                        );




    public abstract ConnectionCloseBody createConnectionCloseBody(	
                                final int replyCode,
                                final AMQShortString replyText,
                                final int classId,
                                final int methodId
	                        );



    public abstract ConnectionCloseOkBody createConnectionCloseOkBody(	
	                        );



    public abstract ConnectionOpenBody createConnectionOpenBody(	
                                final AMQShortString virtualHost,
                                final AMQShortString capabilities,
                                final boolean insist
	                        );



    public abstract ConnectionOpenOkBody createConnectionOpenOkBody(	
                                final AMQShortString knownHosts
	                        );



    public abstract ConnectionSecureBody createConnectionSecureBody(	
                                final byte[] challenge
	                        );



    public abstract ConnectionSecureOkBody createConnectionSecureOkBody(	
                                final byte[] response
	                        );



    public abstract ConnectionStartBody createConnectionStartBody(	
                                final short versionMajor,
                                final short versionMinor,
                                final FieldTable serverProperties,
                                final byte[] mechanisms,
                                final byte[] locales
	                        );



    public abstract ConnectionStartOkBody createConnectionStartOkBody(	
                                final FieldTable clientProperties,
                                final AMQShortString mechanism,
                                final byte[] response,
                                final AMQShortString locale
	                        );



    public abstract ConnectionTuneBody createConnectionTuneBody(	
                                final int channelMax,
                                final long frameMax,
                                final int heartbeat
	                        );



    public abstract ConnectionTuneOkBody createConnectionTuneOkBody(	
                                final int channelMax,
                                final long frameMax,
                                final int heartbeat
	                        );





    public abstract ExchangeBoundBody createExchangeBoundBody(	
                                final AMQShortString exchange,
                                final AMQShortString routingKey,
                                final AMQShortString queue
	                        );



    public abstract ExchangeBoundOkBody createExchangeBoundOkBody(	
                                final int replyCode,
                                final AMQShortString replyText
	                        );



    public abstract ExchangeDeclareBody createExchangeDeclareBody(	
                                final int ticket,
                                final AMQShortString exchange,
                                final AMQShortString type,
                                final boolean passive,
                                final boolean durable,
                                final boolean autoDelete,
                                final boolean internal,
                                final boolean nowait,
                                final FieldTable arguments
	                        );



    public abstract ExchangeDeclareOkBody createExchangeDeclareOkBody(	
	                        );



    public abstract ExchangeDeleteBody createExchangeDeleteBody(	
                                final int ticket,
                                final AMQShortString exchange,
                                final boolean ifUnused,
                                final boolean nowait
	                        );



    public abstract ExchangeDeleteOkBody createExchangeDeleteOkBody(	
	                        );






    public abstract QueueBindBody createQueueBindBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final AMQShortString exchange,
                                final AMQShortString routingKey,
                                final boolean nowait,
                                final FieldTable arguments
	                        );



    public abstract QueueBindOkBody createQueueBindOkBody(	
	                        );



    public abstract QueueDeclareBody createQueueDeclareBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final boolean passive,
                                final boolean durable,
                                final boolean exclusive,
                                final boolean autoDelete,
                                final boolean nowait,
                                final FieldTable arguments
	                        );



    public abstract QueueDeclareOkBody createQueueDeclareOkBody(	
                                final AMQShortString queue,
                                final long messageCount,
                                final long consumerCount
	                        );



    public abstract QueueDeleteBody createQueueDeleteBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final boolean ifUnused,
                                final boolean ifEmpty,
                                final boolean nowait
	                        );



    public abstract QueueDeleteOkBody createQueueDeleteOkBody(	
                                final long messageCount
	                        );



    public abstract QueuePurgeBody createQueuePurgeBody(	
                                final int ticket,
                                final AMQShortString queue,
                                final boolean nowait
	                        );



    public abstract QueuePurgeOkBody createQueuePurgeOkBody(	
                                final long messageCount
	                        );







    public abstract TxCommitBody createTxCommitBody(	
	                        );



    public abstract TxCommitOkBody createTxCommitOkBody(	
	                        );



    public abstract TxRollbackBody createTxRollbackBody(	
	                        );



    public abstract TxRollbackOkBody createTxRollbackOkBody(	
	                        );



    public abstract TxSelectBody createTxSelectBody(	
	                        );



    public abstract TxSelectOkBody createTxSelectOkBody(	
	                        );




	public abstract ProtocolVersionMethodConverter getProtocolVersionMethodConverter();
	
}
