/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/*
 * This file is auto-generated by Qpid Gentools v.0.1 - do not modify.
 * Supported AMQP version:
 *   0-9
 */
 
 
package org.apache.qpid.framing.amqp_0_9;

import org.apache.qpid.codec.MarkableDataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.qpid.framing.*;
import org.apache.qpid.AMQException;

public class MessageAppendBodyImpl extends AMQMethodBody_0_9 implements MessageAppendBody
{
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory()
    {
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException
        {
            return new MessageAppendBodyImpl(in);
        }
		
 
    };
    
	
    public static AMQMethodBodyInstanceFactory getFactory()
    {
        return FACTORY_INSTANCE;
    }

    public static final int CLASS_ID =  120; 
    
    public static final int METHOD_ID = 80; 
    

	
    // Fields declared in specification
    private final byte[] _reference; // [reference]
    private final byte[] _bytes; // [bytes]

    
    // Constructor

    public MessageAppendBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException
    {
        _reference = readBytes( buffer );
        _bytes = readBytes( buffer );
	}
	
    public MessageAppendBodyImpl(
                                byte[] reference,
                                byte[] bytes
                            )
    {
        _reference = reference;
        _bytes = bytes;
    }
    
    public int getClazz() 
    { 
        return CLASS_ID; 
    }
    
    public int getMethod() 
    { 
        return METHOD_ID; 
    }

    
    public final byte[] getReference()
    {
        return _reference;
    }
    public final byte[] getBytes()
    {
        return _bytes;
    }

    protected int getBodySize()
    {      
	    int size = 0;
        size += getSizeOf( _reference );
        size += getSizeOf( _bytes );
        return size;        
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException
    {
        writeBytes( buffer, _reference );
        writeBytes( buffer, _bytes );
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException
	{
    return ((MethodDispatcher_0_9)dispatcher).dispatchMessageAppend(this, channelId);	

	    
	}
	
	
    public String toString()
    {
        StringBuilder buf = new StringBuilder("[MessageAppendBodyImpl: ");
        buf.append( "reference=" );
		buf.append(  getReference() == null  ? "null" : java.util.Arrays.toString( getReference() ) );
		buf.append( ", " );		
        buf.append( "bytes=" );
		buf.append(  getBytes() == null  ? "null" : java.util.Arrays.toString( getBytes() ) );
        buf.append("]");
        return buf.toString();
    }


}
