/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/*
 * This file is auto-generated by Qpid Gentools v.0.1 - do not modify.
 * Supported AMQP version:
 *   0-9
 */
 
 
package org.apache.qpid.framing.amqp_0_9;

import org.apache.qpid.codec.MarkableDataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.qpid.framing.*;
import org.apache.qpid.AMQException;

public class MessageTransferBodyImpl extends AMQMethodBody_0_9 implements MessageTransferBody
{
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory()
    {
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException
        {
            return new MessageTransferBodyImpl(in);
        }
		
 
    };
    
	
    public static AMQMethodBodyInstanceFactory getFactory()
    {
        return FACTORY_INSTANCE;
    }

    public static final int CLASS_ID =  120; 
    
    public static final int METHOD_ID = 10; 
    

	
    // Fields declared in specification
    private final int _ticket; // [ticket]
    private final AMQShortString _destination; // [destination]
    private final byte _bitfield0; // [redelivered, immediate]
    private final long _ttl; // [ttl]
    private final short _priority; // [priority]
    private final long _timestamp; // [timestamp]
    private final short _deliveryMode; // [deliveryMode]
    private final long _expiration; // [expiration]
    private final AMQShortString _exchange; // [exchange]
    private final AMQShortString _routingKey; // [routingKey]
    private final AMQShortString _messageId; // [messageId]
    private final AMQShortString _correlationId; // [correlationId]
    private final AMQShortString _replyTo; // [replyTo]
    private final AMQShortString _contentType; // [contentType]
    private final AMQShortString _contentEncoding; // [contentEncoding]
    private final AMQShortString _userId; // [userId]
    private final AMQShortString _appId; // [appId]
    private final AMQShortString _transactionId; // [transactionId]
    private final byte[] _securityToken; // [securityToken]
    private final FieldTable _applicationHeaders; // [applicationHeaders]
    private final Content _body; // [body]

    
    // Constructor

    public MessageTransferBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException
    {
        _ticket = readUnsignedShort( buffer );
        _destination = readAMQShortString( buffer );
        _bitfield0 = readBitfield( buffer );
        _ttl = readLong( buffer );
        _priority = readUnsignedByte( buffer );
        _timestamp = readTimestamp( buffer );
        _deliveryMode = readUnsignedByte( buffer );
        _expiration = readTimestamp( buffer );
        _exchange = readAMQShortString( buffer );
        _routingKey = readAMQShortString( buffer );
        _messageId = readAMQShortString( buffer );
        _correlationId = readAMQShortString( buffer );
        _replyTo = readAMQShortString( buffer );
        _contentType = readAMQShortString( buffer );
        _contentEncoding = readAMQShortString( buffer );
        _userId = readAMQShortString( buffer );
        _appId = readAMQShortString( buffer );
        _transactionId = readAMQShortString( buffer );
        _securityToken = readBytes( buffer );
        _applicationHeaders = readFieldTable( buffer );
        _body = readContent( buffer );
	}
	
    public MessageTransferBodyImpl(
                                int ticket,
                                AMQShortString destination,
                                boolean redelivered,
                                boolean immediate,
                                long ttl,
                                short priority,
                                long timestamp,
                                short deliveryMode,
                                long expiration,
                                AMQShortString exchange,
                                AMQShortString routingKey,
                                AMQShortString messageId,
                                AMQShortString correlationId,
                                AMQShortString replyTo,
                                AMQShortString contentType,
                                AMQShortString contentEncoding,
                                AMQShortString userId,
                                AMQShortString appId,
                                AMQShortString transactionId,
                                byte[] securityToken,
                                FieldTable applicationHeaders,
                                Content body
                            )
    {
        _ticket = ticket;
        _destination = destination;
        byte bitfield0 = (byte)0;
        if( redelivered )
		{		    
            bitfield0 = (byte) (((int) bitfield0) | (1 << 0));
		}
 
        if( immediate )
		{		    
            bitfield0 = (byte) (((int) bitfield0) | (1 << 1));
		}
 
        _bitfield0 = bitfield0; 
        _ttl = ttl;
        _priority = priority;
        _timestamp = timestamp;
        _deliveryMode = deliveryMode;
        _expiration = expiration;
        _exchange = exchange;
        _routingKey = routingKey;
        _messageId = messageId;
        _correlationId = correlationId;
        _replyTo = replyTo;
        _contentType = contentType;
        _contentEncoding = contentEncoding;
        _userId = userId;
        _appId = appId;
        _transactionId = transactionId;
        _securityToken = securityToken;
        _applicationHeaders = applicationHeaders;
        _body = body;
    }
    
    public int getClazz() 
    { 
        return CLASS_ID; 
    }
    
    public int getMethod() 
    { 
        return METHOD_ID; 
    }

    
    public final int getTicket()
    {
        return _ticket;
    }
    public final AMQShortString getDestination()
    {
        return _destination;
    }
    public final boolean getRedelivered()
    {
        return (((int)(_bitfield0)) & ( 1 << 0)) != 0;
    }
    public final boolean getImmediate()
    {
        return (((int)(_bitfield0)) & ( 1 << 1)) != 0;
    }
    public final long getTtl()
    {
        return _ttl;
    }
    public final short getPriority()
    {
        return _priority;
    }
    public final long getTimestamp()
    {
        return _timestamp;
    }
    public final short getDeliveryMode()
    {
        return _deliveryMode;
    }
    public final long getExpiration()
    {
        return _expiration;
    }
    public final AMQShortString getExchange()
    {
        return _exchange;
    }
    public final AMQShortString getRoutingKey()
    {
        return _routingKey;
    }
    public final AMQShortString getMessageId()
    {
        return _messageId;
    }
    public final AMQShortString getCorrelationId()
    {
        return _correlationId;
    }
    public final AMQShortString getReplyTo()
    {
        return _replyTo;
    }
    public final AMQShortString getContentType()
    {
        return _contentType;
    }
    public final AMQShortString getContentEncoding()
    {
        return _contentEncoding;
    }
    public final AMQShortString getUserId()
    {
        return _userId;
    }
    public final AMQShortString getAppId()
    {
        return _appId;
    }
    public final AMQShortString getTransactionId()
    {
        return _transactionId;
    }
    public final byte[] getSecurityToken()
    {
        return _securityToken;
    }
    public final FieldTable getApplicationHeaders()
    {
        return _applicationHeaders;
    }
    public final Content getBody()
    {
        return _body;
    }

    protected int getBodySize()
    {      
	    int size = 29;
        size += getSizeOf( _destination );
        size += getSizeOf( _exchange );
        size += getSizeOf( _routingKey );
        size += getSizeOf( _messageId );
        size += getSizeOf( _correlationId );
        size += getSizeOf( _replyTo );
        size += getSizeOf( _contentType );
        size += getSizeOf( _contentEncoding );
        size += getSizeOf( _userId );
        size += getSizeOf( _appId );
        size += getSizeOf( _transactionId );
        size += getSizeOf( _securityToken );
        size += getSizeOf( _applicationHeaders );
        size += getSizeOf( _body );
        return size;        
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException
    {
        writeUnsignedShort( buffer, _ticket );
        writeAMQShortString( buffer, _destination );
        writeBitfield( buffer, _bitfield0 );
        writeLong( buffer, _ttl );
        writeUnsignedByte( buffer, _priority );
        writeTimestamp( buffer, _timestamp );
        writeUnsignedByte( buffer, _deliveryMode );
        writeTimestamp( buffer, _expiration );
        writeAMQShortString( buffer, _exchange );
        writeAMQShortString( buffer, _routingKey );
        writeAMQShortString( buffer, _messageId );
        writeAMQShortString( buffer, _correlationId );
        writeAMQShortString( buffer, _replyTo );
        writeAMQShortString( buffer, _contentType );
        writeAMQShortString( buffer, _contentEncoding );
        writeAMQShortString( buffer, _userId );
        writeAMQShortString( buffer, _appId );
        writeAMQShortString( buffer, _transactionId );
        writeBytes( buffer, _securityToken );
        writeFieldTable( buffer, _applicationHeaders );
        writeContent( buffer, _body );
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException
	{
    return ((MethodDispatcher_0_9)dispatcher).dispatchMessageTransfer(this, channelId);	

	    
	}
	
	
    public String toString()
    {
        StringBuilder buf = new StringBuilder("[MessageTransferBodyImpl: ");
        buf.append( "ticket=" );
		buf.append(  getTicket() );
		buf.append( ", " );		
        buf.append( "destination=" );
		buf.append(  getDestination() );
		buf.append( ", " );		
        buf.append( "redelivered=" );
		buf.append(  getRedelivered() );
		buf.append( ", " );		
        buf.append( "immediate=" );
		buf.append(  getImmediate() );
		buf.append( ", " );		
        buf.append( "ttl=" );
		buf.append(  getTtl() );
		buf.append( ", " );		
        buf.append( "priority=" );
		buf.append(  getPriority() );
		buf.append( ", " );		
        buf.append( "timestamp=" );
		buf.append(  getTimestamp() );
		buf.append( ", " );		
        buf.append( "deliveryMode=" );
		buf.append(  getDeliveryMode() );
		buf.append( ", " );		
        buf.append( "expiration=" );
		buf.append(  getExpiration() );
		buf.append( ", " );		
        buf.append( "exchange=" );
		buf.append(  getExchange() );
		buf.append( ", " );		
        buf.append( "routingKey=" );
		buf.append(  getRoutingKey() );
		buf.append( ", " );		
        buf.append( "messageId=" );
		buf.append(  getMessageId() );
		buf.append( ", " );		
        buf.append( "correlationId=" );
		buf.append(  getCorrelationId() );
		buf.append( ", " );		
        buf.append( "replyTo=" );
		buf.append(  getReplyTo() );
		buf.append( ", " );		
        buf.append( "contentType=" );
		buf.append(  getContentType() );
		buf.append( ", " );		
        buf.append( "contentEncoding=" );
		buf.append(  getContentEncoding() );
		buf.append( ", " );		
        buf.append( "userId=" );
		buf.append(  getUserId() );
		buf.append( ", " );		
        buf.append( "appId=" );
		buf.append(  getAppId() );
		buf.append( ", " );		
        buf.append( "transactionId=" );
		buf.append(  getTransactionId() );
		buf.append( ", " );		
        buf.append( "securityToken=" );
		buf.append(  getSecurityToken() == null  ? "null" : java.util.Arrays.toString( getSecurityToken() ) );
		buf.append( ", " );		
        buf.append( "applicationHeaders=" );
		buf.append(  getApplicationHeaders() );
		buf.append( ", " );		
        buf.append( "body=" );
		buf.append(  getBody() );
        buf.append("]");
        return buf.toString();
    }


}
