/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/*
 * This file is auto-generated by Qpid Gentools v.0.1 - do not modify.
 * Supported AMQP version:
 *   8-0
 */
 
 
package org.apache.qpid.framing.amqp_8_0;

import org.apache.qpid.codec.MarkableDataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.qpid.framing.*;
import org.apache.qpid.AMQException;

public class StreamDeliverBodyImpl extends AMQMethodBody_8_0 implements StreamDeliverBody
{
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory()
    {
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException
        {
            return new StreamDeliverBodyImpl(in);
        }
		
 
    };
    
	
    public static AMQMethodBodyInstanceFactory getFactory()
    {
        return FACTORY_INSTANCE;
    }

    public static final int CLASS_ID =  80; 
    
    public static final int METHOD_ID = 60; 
    

	
    // Fields declared in specification
    private final AMQShortString _consumerTag; // [consumerTag]
    private final long _deliveryTag; // [deliveryTag]
    private final AMQShortString _exchange; // [exchange]
    private final AMQShortString _queue; // [queue]

    
    // Constructor

    public StreamDeliverBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException
    {
        _consumerTag = readAMQShortString( buffer );
        _deliveryTag = readLong( buffer );
        _exchange = readAMQShortString( buffer );
        _queue = readAMQShortString( buffer );
	}
	
    public StreamDeliverBodyImpl(
                                AMQShortString consumerTag,
                                long deliveryTag,
                                AMQShortString exchange,
                                AMQShortString queue
                            )
    {
        _consumerTag = consumerTag;
        _deliveryTag = deliveryTag;
        _exchange = exchange;
        _queue = queue;
    }
    
    public int getClazz() 
    { 
        return CLASS_ID; 
    }
    
    public int getMethod() 
    { 
        return METHOD_ID; 
    }

    
    public final AMQShortString getConsumerTag()
    {
        return _consumerTag;
    }
    public final long getDeliveryTag()
    {
        return _deliveryTag;
    }
    public final AMQShortString getExchange()
    {
        return _exchange;
    }
    public final AMQShortString getQueue()
    {
        return _queue;
    }

    protected int getBodySize()
    {      
	    int size = 8;
        size += getSizeOf( _consumerTag );
        size += getSizeOf( _exchange );
        size += getSizeOf( _queue );
        return size;        
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException
    {
        writeAMQShortString( buffer, _consumerTag );
        writeLong( buffer, _deliveryTag );
        writeAMQShortString( buffer, _exchange );
        writeAMQShortString( buffer, _queue );
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException
	{
    return ((MethodDispatcher_8_0)dispatcher).dispatchStreamDeliver(this, channelId);	

	    
	}
	
	
    public String toString()
    {
        StringBuilder buf = new StringBuilder("[StreamDeliverBodyImpl: ");
        buf.append( "consumerTag=" );
		buf.append(  getConsumerTag() );
		buf.append( ", " );		
        buf.append( "deliveryTag=" );
		buf.append(  getDeliveryTag() );
		buf.append( ", " );		
        buf.append( "exchange=" );
		buf.append(  getExchange() );
		buf.append( ", " );		
        buf.append( "queue=" );
		buf.append(  getQueue() );
        buf.append("]");
        return buf.toString();
    }


}
