/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid;

import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.protocol.AMQConstant;

public class AMQException
extends Exception {
    private AMQConstant _errorCode;
    private boolean _isHardError;

    public AMQException(AMQConstant errorCode, String msg, Throwable cause) {
        this(errorCode, true, msg, cause);
    }

    public AMQException(AMQConstant errorCode, boolean isHardError, String msg, Throwable cause) {
        super(msg == null ? "" : msg, cause);
        this._errorCode = errorCode;
        this._isHardError = isHardError;
    }

    @Deprecated
    public AMQException(String msg) {
        this(null, msg == null ? "" : msg);
    }

    @Deprecated
    public AMQException(AMQConstant errorCode, String msg) {
        this(errorCode, msg == null ? "" : msg, null);
    }

    @Deprecated
    public AMQException(String msg, Throwable cause) {
        this(null, msg, cause);
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage() + (this._errorCode == null ? "" : " [error code " + this._errorCode + "]");
    }

    public AMQConstant getErrorCode() {
        return this._errorCode;
    }

    public boolean isHardError() {
        return this._isHardError;
    }

    public AMQException cloneForCurrentThread() {
        AMQException newAMQE;
        Class<?> amqeClass = this.getClass();
        Class[] paramClasses = new Class[]{AMQConstant.class, String.class, Throwable.class};
        Object[] params = new Object[]{this.getErrorCode(), this.getMessage(), this};
        try {
            newAMQE = (AMQException)amqeClass.getConstructor(paramClasses).newInstance(params);
        }
        catch (Exception creationException) {
            newAMQE = new AMQException(this.getErrorCode(), this.getMessage(), this);
        }
        return newAMQE;
    }

    public AMQShortString getMessageAsShortString() {
        String message = this.getMessage();
        return AMQShortString.valueOf(message, true, true);
    }
}

