/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class ChannelCloseBodyImpl
extends AMQMethodBody_0_9
implements ChannelCloseBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new ChannelCloseBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 20;
    public static final int METHOD_ID = 40;
    private final int _replyCode;
    private final AMQShortString _replyText;
    private final int _classId;
    private final int _methodId;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ChannelCloseBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._replyCode = this.readUnsignedShort(buffer);
        this._replyText = this.readAMQShortString(buffer);
        this._classId = this.readUnsignedShort(buffer);
        this._methodId = this.readUnsignedShort(buffer);
    }

    public ChannelCloseBodyImpl(int replyCode, AMQShortString replyText, int classId, int methodId) {
        this._replyCode = replyCode;
        this._replyText = replyText;
        this._classId = classId;
        this._methodId = methodId;
    }

    public int getClazz() {
        return 20;
    }

    public int getMethod() {
        return 40;
    }

    public final int getReplyCode() {
        return this._replyCode;
    }

    public final AMQShortString getReplyText() {
        return this._replyText;
    }

    public final int getClassId() {
        return this._classId;
    }

    public final int getMethodId() {
        return this._methodId;
    }

    protected int getBodySize() {
        int size = 6;
        return size += this.getSizeOf(this._replyText);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._replyCode);
        this.writeAMQShortString(buffer, this._replyText);
        this.writeUnsignedShort(buffer, this._classId);
        this.writeUnsignedShort(buffer, this._methodId);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchChannelClose(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ChannelCloseBodyImpl: ");
        buf.append("replyCode=");
        buf.append(this.getReplyCode());
        buf.append(", ");
        buf.append("replyText=");
        buf.append(this.getReplyText());
        buf.append(", ");
        buf.append("classId=");
        buf.append(this.getClassId());
        buf.append(", ");
        buf.append("methodId=");
        buf.append(this.getMethodId());
        buf.append("]");
        return buf.toString();
    }
}

