/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.StreamConsumeBody;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class StreamConsumeBodyImpl
extends AMQMethodBody_8_0
implements StreamConsumeBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new StreamConsumeBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 80;
    public static final int METHOD_ID = 20;
    private final int _ticket;
    private final AMQShortString _queue;
    private final AMQShortString _consumerTag;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public StreamConsumeBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._ticket = this.readUnsignedShort(buffer);
        this._queue = this.readAMQShortString(buffer);
        this._consumerTag = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public StreamConsumeBodyImpl(int ticket, AMQShortString queue, AMQShortString consumerTag, boolean noLocal, boolean exclusive, boolean nowait) {
        this._ticket = ticket;
        this._queue = queue;
        this._consumerTag = consumerTag;
        byte bitfield0 = 0;
        if (noLocal) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (exclusive) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        this._bitfield0 = bitfield0;
    }

    public int getClazz() {
        return 80;
    }

    public int getMethod() {
        return 20;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    public final boolean getNoLocal() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getExclusive() {
        return (this._bitfield0 & 2) != 0;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 4) != 0;
    }

    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._queue);
        return size += this.getSizeOf(this._consumerTag);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeAMQShortString(buffer, this._consumerTag);
        this.writeBitfield(buffer, this._bitfield0);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchStreamConsume(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[StreamConsumeBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append(", ");
        buf.append("noLocal=");
        buf.append(this.getNoLocal());
        buf.append(", ");
        buf.append("exclusive=");
        buf.append(this.getExclusive());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append("]");
        return buf.toString();
    }
}

