/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.properties;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.apache.qpid.transport.util.Logger;

public class ConnectionStartProperties {
    private static final Logger LOGGER = Logger.get(ConnectionStartProperties.class);
    public static final String QPID_CLOSE_WHEN_NO_ROUTE = "qpid.close_when_no_route";
    public static final String CLIENT_ID_0_10 = "clientName";
    public static final String CLIENT_ID_0_8 = "instance";
    public static final String VERSION_0_8 = "version";
    public static final String VERSION_0_10 = "qpid.client_version";
    public static final String PROCESS = "qpid.client_process";
    public static final String PID = "qpid.client_pid";
    public static final String PLATFORM = "platform";
    public static final String PRODUCT = "product";
    public static final String SESSION_FLOW = "qpid.session_flow";
    public static int _pid;
    public static final String _platformInfo;

    public static int getPID() {
        return _pid;
    }

    public static String getPlatformInfo() {
        return _platformInfo;
    }

    static {
        RuntimeMXBean rtb = ManagementFactory.getRuntimeMXBean();
        String processName = rtb.getName();
        if (processName != null && processName.indexOf(64) > 0) {
            try {
                _pid = Integer.parseInt(processName.substring(0, processName.indexOf(64)));
            }
            catch (Exception e) {
                LOGGER.warn("Unable to get the PID due to error", e);
                _pid = -1;
            }
        } else {
            LOGGER.warn("Unable to get the PID due to unsupported format : " + processName, new Object[0]);
            _pid = -1;
        }
        StringBuilder fullSystemInfo = new StringBuilder(System.getProperty("java.runtime.name"));
        fullSystemInfo.append(", ");
        fullSystemInfo.append(System.getProperty("java.runtime.version"));
        fullSystemInfo.append(", ");
        fullSystemInfo.append(System.getProperty("java.vendor"));
        fullSystemInfo.append(", ");
        fullSystemInfo.append(System.getProperty("os.arch"));
        fullSystemInfo.append(", ");
        fullSystemInfo.append(System.getProperty("os.name"));
        fullSystemInfo.append(", ");
        fullSystemInfo.append(System.getProperty("os.version"));
        fullSystemInfo.append(", ");
        fullSystemInfo.append(System.getProperty("sun.os.patch.level"));
        _platformInfo = fullSystemInfo.toString();
    }
}

