/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security.ssl;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.SenderException;
import org.apache.qpid.transport.network.security.SSLStatus;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.transport.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLBufferingSender
implements Sender<ByteBuffer> {
    private static final Logger log = Logger.get(SSLBufferingSender.class);
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private final Sender<ByteBuffer> delegate;
    private final SSLEngine engine;
    private final int sslBufSize;
    private final ByteBuffer netData;
    private final SSLStatus _sslStatus;
    private String _hostname;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private ByteBuffer _appData = EMPTY_BYTE_BUFFER;

    public SSLBufferingSender(SSLEngine engine, Sender<ByteBuffer> delegate, SSLStatus sslStatus) {
        this.engine = engine;
        this.delegate = delegate;
        this.sslBufSize = engine.getSession().getPacketBufferSize();
        this.netData = ByteBuffer.allocate(this.sslBufSize);
        this._sslStatus = sslStatus;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.engine.isOutboundDone()) {
                return;
            }
            log.debug("Closing SSL connection", new Object[0]);
            this.doSend();
            this.engine.closeOutbound();
            try {
                this.tearDownSSLConnection();
            }
            catch (Exception e) {
                throw new SenderException("Error closing SSL connection", e);
            }
            Object object = this._sslStatus.getSslLock();
            synchronized (object) {
                while (!this.engine.isOutboundDone()) {
                    try {
                        this._sslStatus.getSslLock().wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.delegate.close();
        }
    }

    private void tearDownSSLConnection() throws Exception {
        SSLEngineResult result = this.engine.wrap(ByteBuffer.allocate(0), this.netData);
        SSLEngineResult.Status status = result.getStatus();
        int read = result.bytesProduced();
        while (status != SSLEngineResult.Status.CLOSED) {
            if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.netData.clear();
            }
            if (read > 0) {
                int limit = this.netData.limit();
                this.netData.limit(this.netData.position());
                this.netData.position(this.netData.position() - read);
                ByteBuffer data = this.netData.slice();
                this.netData.limit(limit);
                this.netData.position(this.netData.position() + read);
                this.delegate.send(data);
                this.flush();
            }
            result = this.engine.wrap(ByteBuffer.allocate(0), this.netData);
            status = result.getStatus();
            read = result.bytesProduced();
        }
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    public void send() {
        if (!this.closed.get()) {
            this.doSend();
        }
    }

    @Override
    public synchronized void send(ByteBuffer appData) {
        boolean buffered = this._appData.hasRemaining();
        if (buffered) {
            ByteBuffer newBuf = ByteBuffer.allocate(this._appData.remaining() + appData.remaining());
            newBuf.put(this._appData);
            newBuf.put(appData);
            newBuf.flip();
            this._appData = newBuf;
        }
        if (this.closed.get()) {
            throw new SenderException("SSL Sender is closed");
        }
        this.doSend();
        if (!appData.hasRemaining()) {
            this._appData = EMPTY_BYTE_BUFFER;
        } else if (!buffered) {
            this._appData = ByteBuffer.allocate(appData.remaining());
            this._appData.put(appData);
            this._appData.flip();
        }
    }

    private synchronized void doSend() {
        block14: while ((this._appData.hasRemaining() || this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) && !this._sslStatus.getSslErrorFlag()) {
            SSLEngineResult.HandshakeStatus handshakeStatus;
            SSLEngineResult.Status status;
            int read = 0;
            try {
                SSLEngineResult result = this.engine.wrap(this._appData, this.netData);
                read = result.bytesProduced();
                status = result.getStatus();
                handshakeStatus = result.getHandshakeStatus();
            }
            catch (SSLException e) {
                throw new SenderException("SSL, Error occurred while encrypting data", e);
            }
            if (read > 0) {
                int limit = this.netData.limit();
                this.netData.limit(this.netData.position());
                this.netData.position(this.netData.position() - read);
                ByteBuffer data = this.netData.slice();
                this.netData.limit(limit);
                this.netData.position(this.netData.position() + read);
                this.delegate.send(data);
            }
            switch (status) {
                case CLOSED: {
                    throw new SenderException("SSLEngine is closed");
                }
                case BUFFER_OVERFLOW: {
                    this.netData.clear();
                    continue block14;
                }
                case OK: {
                    break;
                }
                default: {
                    throw new IllegalStateException("SSLReceiver: Invalid State " + (Object)((Object)status));
                }
            }
            switch (handshakeStatus) {
                case NEED_WRAP: {
                    if (this.netData.hasRemaining()) continue block14;
                }
                case NEED_TASK: {
                    this.doTasks();
                    continue block14;
                }
                case NEED_UNWRAP: {
                    this.flush();
                    return;
                }
                case FINISHED: {
                    if (this._hostname != null) {
                        SSLUtil.verifyHostname(this.engine, this._hostname);
                    }
                }
                case NOT_HANDSHAKING: {
                    continue block14;
                }
            }
            throw new IllegalStateException("SSLSender: Invalid State " + (Object)((Object)status));
        }
    }

    private void doTasks() {
        Runnable runnable;
        while ((runnable = this.engine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }

    @Override
    public void setIdleTimeout(int i) {
        this.delegate.setIdleTimeout(i);
    }
}

