/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/*
 * This file is auto-generated by Qpid Gentools v.0.1 - do not modify.
 * Supported AMQP version:
 *   8-0
 */

package org.apache.qpid.framing.amqp_8_0;

import org.apache.qpid.codec.MarkableDataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.qpid.framing.*;
import org.apache.qpid.AMQException;

public class TestTableBodyImpl extends AMQMethodBody_8_0 implements TestTableBody
{
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory()
    {
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException
        {
            return new TestTableBodyImpl(in);
        }
    };

    public static AMQMethodBodyInstanceFactory getFactory()
    {
        return FACTORY_INSTANCE;
    }

    public static final int CLASS_ID =  120;
    public static final int METHOD_ID = 30;

    // Fields declared in specification
    private final FieldTable _table; // [table]
    private final short _integerOp; // [integerOp]
    private final short _stringOp; // [stringOp]

    // Constructor
    public TestTableBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException
    {
        _table = readFieldTable( buffer );
        _integerOp = readUnsignedByte( buffer );
        _stringOp = readUnsignedByte( buffer );
    }

    public TestTableBodyImpl(
                                FieldTable table,
                                short integerOp,
                                short stringOp
                            )
    {
        _table = table;
        _integerOp = integerOp;
        _stringOp = stringOp;
    }

    public int getClazz()
    {
        return CLASS_ID;
    }

    public int getMethod()
    {
        return METHOD_ID;
    }

    public final FieldTable getTable()
    {
        return _table;
    }
    public final short getIntegerOp()
    {
        return _integerOp;
    }
    public final short getStringOp()
    {
        return _stringOp;
    }

    protected int getBodySize()
    {
        int size = 2;
        size += getSizeOf( _table );
        return size;
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException
    {
        writeFieldTable( buffer, _table );
        writeUnsignedByte( buffer, _integerOp );
        writeUnsignedByte( buffer, _stringOp );
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException
	{
    return ((MethodDispatcher_8_0)dispatcher).dispatchTestTable(this, channelId);
	}

    public String toString()
    {
        StringBuilder buf = new StringBuilder("[TestTableBodyImpl: ");
        buf.append( "table=" );
        buf.append(  getTable() );
        buf.append( ", " );
        buf.append( "integerOp=" );
        buf.append(  getIntegerOp() );
        buf.append( ", " );
        buf.append( "stringOp=" );
        buf.append(  getStringOp() );
        buf.append("]");
        return buf.toString();
    }

}
