/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.bytebuffer;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

class BufferPool {
    private final int _maxSize;
    private final ConcurrentLinkedQueue<ByteBuffer> _pooledBuffers = new ConcurrentLinkedQueue();

    BufferPool(int maxSize) {
        this._maxSize = maxSize;
    }

    ByteBuffer getBuffer() {
        return this._pooledBuffers.poll();
    }

    void returnBuffer(ByteBuffer buf) {
        buf.clear();
        if (this._pooledBuffers.size() < this._maxSize) {
            this._pooledBuffers.add(buf);
        }
    }

    public int getMaxSize() {
        return this._maxSize;
    }
}

