/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.qpid.codec.AMQDecoder;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.AccessRequestOkBody;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicConsumeOkBody;
import org.apache.qpid.framing.BasicDeliverBody;
import org.apache.qpid.framing.BasicGetEmptyBody;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicNackBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.ByteBufferListDataInput;
import org.apache.qpid.framing.ChannelAlertBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelFlowBody;
import org.apache.qpid.framing.ChannelFlowOkBody;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.ClientChannelMethodProcessor;
import org.apache.qpid.framing.ClientMethodProcessor;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionOpenOkBody;
import org.apache.qpid.framing.ConnectionRedirectBody;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.ExchangeBoundOkBody;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.framing.QueueDeleteOkBody;
import org.apache.qpid.framing.QueuePurgeOkBody;

public class ClientDecoder
extends AMQDecoder<ClientMethodProcessor<? extends ClientChannelMethodProcessor>> {
    private List<ByteBuffer> _incompleteBuffers = new ArrayList<ByteBuffer>();

    public ClientDecoder(ClientMethodProcessor<? extends ClientChannelMethodProcessor> methodProcessor) {
        super(false, methodProcessor);
    }

    public void decodeBuffer(ByteBuffer buf) throws AMQFrameDecodingException, AMQProtocolVersionException, IOException {
        buf = buf.slice();
        this._incompleteBuffers.add(buf);
        ByteBufferListDataInput msg = new ByteBufferListDataInput(this._incompleteBuffers);
        this.decode(msg);
        ListIterator<ByteBuffer> iter = this._incompleteBuffers.listIterator();
        while (iter.hasNext()) {
            ByteBuffer next = iter.next();
            if (next.hasRemaining()) {
                if (next.position() == 0) break;
                iter.set(next.slice());
                break;
            }
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void processMethod(int channelId, MarkableDataInput in) throws AMQFrameDecodingException, IOException {
        ClientMethodProcessor methodProcessor = (ClientMethodProcessor)this.getMethodProcessor();
        ClientChannelMethodProcessor channelMethodProcessor = (ClientChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId);
        int classAndMethod = in.readInt();
        int classId = classAndMethod >> 16;
        int methodId = classAndMethod & 0xFFFF;
        methodProcessor.setCurrentMethod(classId, methodId);
        try {
            switch (classAndMethod) {
                case 655370: {
                    ConnectionStartBody.process(in, methodProcessor);
                    return;
                }
                case 655380: {
                    ConnectionSecureBody.process(in, methodProcessor);
                    return;
                }
                case 655390: {
                    ConnectionTuneBody.process(in, methodProcessor);
                    return;
                }
                case 655401: {
                    ConnectionOpenOkBody.process(in, methodProcessor);
                    return;
                }
                case 655402: {
                    ConnectionRedirectBody.process(in, methodProcessor);
                    return;
                }
                case 655410: {
                    if (methodProcessor.getProtocolVersion().equals(ProtocolVersion.v0_8)) {
                        ConnectionRedirectBody.process(in, methodProcessor);
                        return;
                    } else {
                        ConnectionCloseBody.process(in, methodProcessor);
                        return;
                    }
                }
                case 655411: {
                    if (methodProcessor.getProtocolVersion().equals(ProtocolVersion.v0_8)) {
                        throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                    }
                    methodProcessor.receiveConnectionCloseOk();
                    return;
                }
                case 655420: {
                    if (!methodProcessor.getProtocolVersion().equals(ProtocolVersion.v0_8)) throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                    ConnectionCloseBody.process(in, methodProcessor);
                    return;
                }
                case 655421: {
                    if (!methodProcessor.getProtocolVersion().equals(ProtocolVersion.v0_8)) throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                    methodProcessor.receiveConnectionCloseOk();
                    return;
                }
                case 1310731: {
                    ChannelOpenOkBody.process(in, methodProcessor.getProtocolVersion(), channelMethodProcessor);
                    return;
                }
                case 0x140014: {
                    ChannelFlowBody.process(in, channelMethodProcessor);
                    return;
                }
                case 1310741: {
                    ChannelFlowOkBody.process(in, channelMethodProcessor);
                    return;
                }
                case 1310750: {
                    ChannelAlertBody.process(in, channelMethodProcessor);
                    return;
                }
                case 1310760: {
                    ChannelCloseBody.process(in, channelMethodProcessor);
                    return;
                }
                case 1310761: {
                    channelMethodProcessor.receiveChannelCloseOk();
                    return;
                }
                case 1966091: {
                    AccessRequestOkBody.process(in, channelMethodProcessor);
                    return;
                }
                case 2621451: {
                    if (channelMethodProcessor.ignoreAllButCloseOk()) return;
                    channelMethodProcessor.receiveExchangeDeclareOk();
                    return;
                }
                case 2621461: {
                    if (channelMethodProcessor.ignoreAllButCloseOk()) return;
                    channelMethodProcessor.receiveExchangeDeleteOk();
                    return;
                }
                case 2621463: {
                    ExchangeBoundOkBody.process(in, channelMethodProcessor);
                    return;
                }
                case 3276811: {
                    QueueDeclareOkBody.process(in, channelMethodProcessor);
                    return;
                }
                case 3276821: {
                    if (channelMethodProcessor.ignoreAllButCloseOk()) return;
                    channelMethodProcessor.receiveQueueBindOk();
                    return;
                }
                case 3276831: {
                    QueuePurgeOkBody.process(in, channelMethodProcessor);
                    return;
                }
                case 3276841: {
                    QueueDeleteOkBody.process(in, channelMethodProcessor);
                    return;
                }
                case 0x320033: {
                    if (channelMethodProcessor.ignoreAllButCloseOk()) return;
                    channelMethodProcessor.receiveQueueUnbindOk();
                    return;
                }
                case 3932171: {
                    if (channelMethodProcessor.ignoreAllButCloseOk()) return;
                    channelMethodProcessor.receiveBasicQosOk();
                    return;
                }
                case 3932181: {
                    BasicConsumeOkBody.process(in, channelMethodProcessor);
                    return;
                }
                case 3932191: {
                    BasicCancelOkBody.process(in, channelMethodProcessor);
                    return;
                }
                case 3932210: {
                    BasicReturnBody.process(in, channelMethodProcessor);
                    return;
                }
                case 0x3C003C: {
                    BasicDeliverBody.process(in, channelMethodProcessor);
                    return;
                }
                case 3932231: {
                    BasicGetOkBody.process(in, channelMethodProcessor);
                    return;
                }
                case 3932232: {
                    BasicGetEmptyBody.process(in, channelMethodProcessor);
                    return;
                }
                case 3932240: {
                    BasicAckBody.process(in, channelMethodProcessor);
                    return;
                }
                case 3932261: {
                    if (channelMethodProcessor.ignoreAllButCloseOk()) return;
                    channelMethodProcessor.receiveBasicRecoverSyncOk();
                    return;
                }
                case 3932271: {
                    if (channelMethodProcessor.ignoreAllButCloseOk()) return;
                    channelMethodProcessor.receiveBasicRecoverSyncOk();
                    return;
                }
                case 3932280: {
                    BasicNackBody.process(in, channelMethodProcessor);
                    return;
                }
                case 0x55000B: {
                    if (channelMethodProcessor.ignoreAllButCloseOk()) return;
                    channelMethodProcessor.receiveConfirmSelectOk();
                    return;
                }
                case 5898251: {
                    if (channelMethodProcessor.ignoreAllButCloseOk()) return;
                    channelMethodProcessor.receiveTxSelectOk();
                    return;
                }
                case 5898261: {
                    if (channelMethodProcessor.ignoreAllButCloseOk()) return;
                    channelMethodProcessor.receiveTxCommitOk();
                    return;
                }
                case 5898271: {
                    if (channelMethodProcessor.ignoreAllButCloseOk()) return;
                    channelMethodProcessor.receiveTxRollbackOk();
                    return;
                }
                default: {
                    throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                }
            }
        }
        finally {
            methodProcessor.setCurrentMethod(0, 0);
        }
    }
}

