/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.codec;

import java.io.IOException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.codec.AMQDecoder;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.AccessRequestBody;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.BasicConsumeBody;
import org.apache.qpid.framing.BasicGetBody;
import org.apache.qpid.framing.BasicNackBody;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.BasicQosBody;
import org.apache.qpid.framing.BasicRecoverBody;
import org.apache.qpid.framing.BasicRecoverSyncBody;
import org.apache.qpid.framing.BasicRejectBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelFlowBody;
import org.apache.qpid.framing.ChannelFlowOkBody;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.ConfirmSelectBody;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionOpenBody;
import org.apache.qpid.framing.ConnectionSecureOkBody;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.ConnectionTuneOkBody;
import org.apache.qpid.framing.ExchangeBoundBody;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.ExchangeDeleteBody;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.QueueBindBody;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.QueueDeleteBody;
import org.apache.qpid.framing.QueuePurgeBody;
import org.apache.qpid.framing.QueueUnbindBody;
import org.apache.qpid.framing.ServerChannelMethodProcessor;
import org.apache.qpid.framing.ServerMethodProcessor;

public class ServerDecoder
extends AMQDecoder<ServerMethodProcessor<? extends ServerChannelMethodProcessor>> {
    public ServerDecoder(ServerMethodProcessor<? extends ServerChannelMethodProcessor> methodProcessor) {
        super(true, methodProcessor);
    }

    public void decodeBuffer(QpidByteBuffer buf) throws AMQFrameDecodingException, AMQProtocolVersionException, IOException {
        this.decode(buf.asDataInput());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void processMethod(int channelId, MarkableDataInput in) throws AMQFrameDecodingException, IOException {
        ServerMethodProcessor methodProcessor = (ServerMethodProcessor)this.getMethodProcessor();
        int classAndMethod = in.readInt();
        int classId = classAndMethod >> 16;
        int methodId = classAndMethod & 0xFFFF;
        methodProcessor.setCurrentMethod(classId, methodId);
        try {
            switch (classAndMethod) {
                case 655371: {
                    ConnectionStartOkBody.process(in, methodProcessor);
                    return;
                }
                case 655381: {
                    ConnectionSecureOkBody.process(in, methodProcessor);
                    return;
                }
                case 655391: {
                    ConnectionTuneOkBody.process(in, methodProcessor);
                    return;
                }
                case 655400: {
                    ConnectionOpenBody.process(in, methodProcessor);
                    return;
                }
                case 655410: {
                    if (methodProcessor.getProtocolVersion().equals(ProtocolVersion.v0_8)) {
                        throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                    }
                    ConnectionCloseBody.process(in, methodProcessor);
                    return;
                }
                case 655411: {
                    if (methodProcessor.getProtocolVersion().equals(ProtocolVersion.v0_8)) {
                        throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                    }
                    methodProcessor.receiveConnectionCloseOk();
                    return;
                }
                case 655420: {
                    if (!methodProcessor.getProtocolVersion().equals(ProtocolVersion.v0_8)) throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                    ConnectionCloseBody.process(in, methodProcessor);
                    return;
                }
                case 655421: {
                    if (!methodProcessor.getProtocolVersion().equals(ProtocolVersion.v0_8)) throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                    methodProcessor.receiveConnectionCloseOk();
                    return;
                }
                case 1310730: {
                    ChannelOpenBody.process(channelId, in, methodProcessor);
                    return;
                }
                case 0x140014: {
                    ChannelFlowBody.process(in, methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 1310741: {
                    ChannelFlowOkBody.process(in, methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 1310760: {
                    ChannelCloseBody.process(in, methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 1310761: {
                    ((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).receiveChannelCloseOk();
                    return;
                }
                case 1966090: {
                    AccessRequestBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 2621450: {
                    ExchangeDeclareBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 2621460: {
                    ExchangeDeleteBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 2621462: {
                    ExchangeBoundBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3276810: {
                    QueueDeclareBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3276820: {
                    QueueBindBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3276830: {
                    QueuePurgeBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3276840: {
                    QueueDeleteBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 0x320032: {
                    QueueUnbindBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932170: {
                    BasicQosBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932180: {
                    BasicConsumeBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932190: {
                    BasicCancelBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932200: {
                    BasicPublishBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932230: {
                    BasicGetBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932240: {
                    BasicAckBody.process(in, methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932250: {
                    BasicRejectBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932260: {
                    BasicRecoverBody.process(in, methodProcessor.getProtocolVersion(), (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932262: {
                    BasicRecoverSyncBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932270: {
                    BasicRecoverSyncBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932280: {
                    BasicNackBody.process(in, methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 0x55000A: {
                    ConfirmSelectBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 0x5A000A: {
                    if (((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).ignoreAllButCloseOk()) return;
                    ((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).receiveTxSelect();
                    return;
                }
                case 5898260: {
                    if (((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).ignoreAllButCloseOk()) return;
                    ((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).receiveTxCommit();
                    return;
                }
                case 5898270: {
                    if (((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).ignoreAllButCloseOk()) return;
                    ((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).receiveTxRollback();
                    return;
                }
                default: {
                    throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                }
            }
        }
        finally {
            methodProcessor.setCurrentMethod(0, 0);
        }
    }
}

