/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonProperties.class);
    public static final String IO_NETWORK_TRANSPORT_TIMEOUT_PROP_NAME = "qpid.io_network_transport_timeout";
    public static final int IO_NETWORK_TRANSPORT_TIMEOUT_DEFAULT = 60000;
    public static final String QPID_SECURITY_TLS_PROTOCOL_WHITE_LIST = "qpid.security.tls.protocolWhiteList";
    public static final String QPID_SECURITY_TLS_PROTOCOL_WHITE_LIST_DEFAULT = "TLS.*";
    public static final String QPID_SECURITY_TLS_PROTOCOL_BLACK_LIST = "qpid.security.tls.protocolBlackList";
    public static final String QPID_SECURITY_TLS_PROTOCOL_BLACK_LIST_DEFAULT = "";
    public static final String QPID_SECURITY_TLS_CIPHER_SUITE_WHITE_LIST = "qpid.security.tls.cipherSuiteWhiteList";
    public static final String QPID_SECURITY_TLS_CIPHER_SUITE_WHITE_LIST_DEFAULT = "";
    public static final String QPID_SECURITY_TLS_CIPHER_SUITE_BLACK_LIST = "qpid.security.tls.cipherSuiteBlackList";
    public static final String QPID_SECURITY_TLS_CIPHER_SUITE_BLACK_LIST_DEFAULT = "";
    public static final String VERSION_RESOURCE = "qpidversion.properties";
    public static final String PRODUCT_NAME_PROPERTY = "qpid.name";
    public static final String RELEASE_VERSION_PROPERTY = "qpid.version";
    public static final String RELEASE_VERSION_SUFFIX = "qpid.version.suffix";
    public static final String BUILD_VERSION_PROPERTY = "qpid.svnversion";
    private static final String DEFAULT = "unknown";
    private static final String productName;
    private static final String releaseVersion;
    private static final int releaseVersionMajor;
    private static final int releaseVersionMinor;
    private static final String buildVersion;
    private static final Properties properties;

    public static void ensureIsLoaded() {
    }

    public static Properties asProperties() {
        return new Properties(properties);
    }

    public static String getProductName() {
        return productName;
    }

    public static String getReleaseVersion() {
        return releaseVersion;
    }

    public static int getReleaseVersionMajor() {
        return releaseVersionMajor;
    }

    public static int getReleaseVersionMinor() {
        return releaseVersionMinor;
    }

    public static String getBuildVersion() {
        return buildVersion;
    }

    public static String getVersionString() {
        return CommonProperties.getProductName() + " - " + CommonProperties.getReleaseVersion() + " build: " + CommonProperties.getBuildVersion();
    }

    private CommonProperties() {
    }

    private static void loadProperties(Properties properties, String resourceLocation, boolean loadFromFile) {
        block17: {
            try {
                URL propertiesResource = loadFromFile ? new File(resourceLocation).toURI().toURL() : CommonProperties.class.getClassLoader().getResource(resourceLocation);
                if (propertiesResource == null) break block17;
                try (InputStream propertyStream = propertiesResource.openStream();){
                    if (propertyStream != null) {
                        properties.load(propertyStream);
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Could not load properties file '{}'.", (Object)resourceLocation, (Object)e);
                }
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Could not open properties file '{}'.", (Object)resourceLocation, (Object)e);
            }
        }
    }

    static {
        properties = new Properties();
        CommonProperties.loadProperties(properties, VERSION_RESOURCE, false);
        buildVersion = properties.getProperty(BUILD_VERSION_PROPERTY, DEFAULT);
        productName = properties.getProperty(PRODUCT_NAME_PROPERTY, DEFAULT);
        String version = properties.getProperty(RELEASE_VERSION_PROPERTY, DEFAULT);
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+).*");
        Matcher m = pattern.matcher(version);
        if (m.matches()) {
            releaseVersionMajor = Integer.parseInt(m.group(1));
            releaseVersionMinor = Integer.parseInt(m.group(2));
        } else {
            LOGGER.warn("Failed to parse major and minor release number from '{}')", (Object)version);
            releaseVersionMajor = -1;
            releaseVersionMinor = -1;
        }
        boolean loadFromFile = true;
        String initialProperties = System.getProperty("qpid.common_properties_file");
        if (initialProperties == null) {
            initialProperties = "qpid-common.properties";
            loadFromFile = false;
        }
        CommonProperties.loadProperties(properties, initialProperties, loadFromFile);
        String versionSuffix = properties.getProperty(RELEASE_VERSION_SUFFIX);
        releaseVersion = versionSuffix == null || "".equals(versionSuffix) ? version : version + ";" + versionSuffix;
        HashSet<String> propertyNames = new HashSet<String>(properties.stringPropertyNames());
        propertyNames.removeAll(System.getProperties().stringPropertyNames());
        for (String propName : propertyNames) {
            System.setProperty(propName, properties.getProperty(propName));
        }
    }
}

