/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.transport.ByteBufferSender;

public class AMQFrame
extends AMQDataBlock
implements EncodableAMQDataBlock {
    private static final int HEADER_SIZE = 7;
    private final int _channel;
    private final AMQBody _bodyFrame;
    public static final byte FRAME_END_BYTE = -50;
    private static final QpidByteBuffer FRAME_END_BYTE_BUFFER = QpidByteBuffer.allocateDirect(1);

    public AMQFrame(int channel, AMQBody bodyFrame) {
        this._channel = channel;
        this._bodyFrame = bodyFrame;
    }

    @Override
    public long getSize() {
        return 7 + this._bodyFrame.getSize() + 1;
    }

    public static final int getFrameOverhead() {
        return 8;
    }

    @Override
    public void writePayload(DataOutput buffer) throws IOException {
        buffer.writeByte(this._bodyFrame.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, this._channel);
        EncodingUtils.writeUnsignedInteger(buffer, (long)this._bodyFrame.getSize());
        this._bodyFrame.writePayload(buffer);
        buffer.writeByte(-50);
    }

    @Override
    public long writePayload(ByteBufferSender sender) throws IOException {
        QpidByteBuffer frameHeader = QpidByteBuffer.allocateDirect(7);
        frameHeader.put(this._bodyFrame.getFrameType());
        EncodingUtils.writeUnsignedShort(frameHeader, this._channel);
        EncodingUtils.writeUnsignedInteger(frameHeader, (long)this._bodyFrame.getSize());
        frameHeader.flip();
        sender.send(frameHeader);
        frameHeader.dispose();
        long size = 8L + this._bodyFrame.writePayload(sender);
        sender.send(FRAME_END_BYTE_BUFFER.duplicate());
        return size;
    }

    public final int getChannel() {
        return this._channel;
    }

    public final AMQBody getBodyFrame() {
        return this._bodyFrame;
    }

    public String toString() {
        return "Frame channelId: " + this._channel + ", bodyFrame: " + String.valueOf(this._bodyFrame);
    }

    public static void writeFrame(DataOutput buffer, int channel, AMQBody body) throws IOException {
        buffer.writeByte(body.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, (long)body.getSize());
        body.writePayload(buffer);
        buffer.writeByte(-50);
    }

    public static void writeFrames(DataOutput buffer, int channel, AMQBody body1, AMQBody body2) throws IOException {
        buffer.writeByte(body1.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, (long)body1.getSize());
        body1.writePayload(buffer);
        buffer.writeByte(-50);
        buffer.writeByte(body2.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, (long)body2.getSize());
        body2.writePayload(buffer);
        buffer.writeByte(-50);
    }

    public static void writeFrames(DataOutput buffer, int channel, AMQBody body1, AMQBody body2, AMQBody body3) throws IOException {
        buffer.writeByte(body1.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, (long)body1.getSize());
        body1.writePayload(buffer);
        buffer.writeByte(-50);
        buffer.writeByte(body2.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, (long)body2.getSize());
        body2.writePayload(buffer);
        buffer.writeByte(-50);
        buffer.writeByte(body3.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, (long)body3.getSize());
        body3.writePayload(buffer);
        buffer.writeByte(-50);
    }

    static {
        FRAME_END_BYTE_BUFFER.put((byte)-50);
        FRAME_END_BYTE_BUFFER.flip();
    }
}

