/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQChannelException;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.transport.ByteBufferSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQMethodBodyImpl
implements AMQMethodBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQMethodBodyImpl.class);
    public static final byte TYPE = 1;

    @Override
    public byte getFrameType() {
        return 1;
    }

    protected abstract int getBodySize();

    @Override
    public AMQFrame generateFrame(int channelId) {
        return new AMQFrame(channelId, this);
    }

    @Override
    public AMQChannelException getChannelNotFoundException(int channelId, MethodRegistry methodRegistry) {
        return this.getChannelException(AMQConstant.NOT_FOUND, "Channel not found for id:" + channelId, methodRegistry);
    }

    @Override
    public AMQChannelException getChannelException(AMQConstant code, String message, MethodRegistry methodRegistry) {
        return new AMQChannelException(code, message, this.getClazz(), this.getMethod(), methodRegistry);
    }

    @Override
    public AMQConnectionException getConnectionException(AMQConstant code, String message, MethodRegistry methodRegistry) {
        return new AMQConnectionException(code, message, this, methodRegistry);
    }

    @Override
    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws QpidException {
        session.methodFrameReceived(channelId, this);
    }

    @Override
    public int getSize() {
        return 4 + this.getBodySize();
    }

    @Override
    public void writePayload(DataOutput buffer) throws IOException {
        EncodingUtils.writeUnsignedShort(buffer, this.getClazz());
        EncodingUtils.writeUnsignedShort(buffer, this.getMethod());
        this.writeMethodPayload(buffer);
    }

    @Override
    public long writePayload(ByteBufferSender sender) throws IOException {
        int size = this.getSize();
        QpidByteBuffer buf = QpidByteBuffer.allocateDirect(size);
        DataOutput dataOutput = buf.asDataOutput();
        this.writePayload(dataOutput);
        buf.flip();
        sender.send(buf);
        buf.dispose();
        return size;
    }

    protected int getSizeOf(AMQShortString string) {
        return EncodingUtils.encodedShortStringLength(string);
    }

    protected void writeByte(DataOutput buffer, byte b) throws IOException {
        buffer.writeByte(b);
    }

    protected void writeAMQShortString(DataOutput buffer, AMQShortString string) throws IOException {
        EncodingUtils.writeShortStringBytes(buffer, string);
    }

    protected int readInt(DataInput buffer) throws IOException {
        return buffer.readInt();
    }

    protected void writeInt(DataOutput buffer, int i) throws IOException {
        buffer.writeInt(i);
    }

    protected int getSizeOf(FieldTable table) {
        return EncodingUtils.encodedFieldTableLength(table);
    }

    protected void writeFieldTable(DataOutput buffer, FieldTable table) throws IOException {
        EncodingUtils.writeFieldTableBytes(buffer, table);
    }

    protected void writeLong(DataOutput buffer, long l) throws IOException {
        buffer.writeLong(l);
    }

    protected int getSizeOf(byte[] response) {
        return response == null ? 4 : response.length + 4;
    }

    protected void writeBytes(DataOutput buffer, byte[] data) throws IOException {
        EncodingUtils.writeBytes(buffer, data);
    }

    protected short readShort(DataInput buffer) throws IOException {
        return EncodingUtils.readShort(buffer);
    }

    protected void writeShort(DataOutput buffer, short s) throws IOException {
        EncodingUtils.writeShort(buffer, s);
    }

    protected void writeBitfield(DataOutput buffer, byte bitfield0) throws IOException {
        buffer.writeByte(bitfield0);
    }

    protected void writeUnsignedShort(DataOutput buffer, int s) throws IOException {
        EncodingUtils.writeUnsignedShort(buffer, s);
    }

    protected void writeUnsignedInteger(DataOutput buffer, long i) throws IOException {
        EncodingUtils.writeUnsignedInteger(buffer, i);
    }

    protected void writeUnsignedByte(DataOutput buffer, short unsignedByte) throws IOException {
        EncodingUtils.writeUnsignedByte(buffer, unsignedByte);
    }

    protected long readTimestamp(DataInput buffer) throws IOException {
        return EncodingUtils.readTimestamp(buffer);
    }

    protected void writeTimestamp(DataOutput buffer, long t) throws IOException {
        EncodingUtils.writeTimestamp(buffer, t);
    }
}

