/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;

public class BasicCancelBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 30;
    private final AMQShortString _consumerTag;
    private final byte _bitfield0;

    public BasicCancelBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._consumerTag = buffer.readAMQShortString();
        this._bitfield0 = buffer.readByte();
    }

    public BasicCancelBody(AMQShortString consumerTag, boolean nowait) {
        this._consumerTag = consumerTag;
        byte bitfield0 = 0;
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 30;
    }

    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 1;
        return size += this.getSizeOf(this._consumerTag);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._consumerTag);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicCancel(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicCancelBodyImpl: ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ServerChannelMethodProcessor dispatcher) throws IOException {
        boolean noWait;
        AMQShortString consumerTag = buffer.readAMQShortString();
        boolean bl = noWait = (buffer.readByte() & 1) == 1;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicCancel(consumerTag, noWait);
        }
    }
}

