/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.ChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;

public class ChannelFlowOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 20;
    public static final int METHOD_ID = 21;
    private final boolean _active;

    public ChannelFlowOkBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._active = (buffer.readByte() & 1) == 1;
    }

    public ChannelFlowOkBody(boolean active) {
        this._active = active;
    }

    @Override
    public int getClazz() {
        return 20;
    }

    @Override
    public int getMethod() {
        return 21;
    }

    public final boolean getActive() {
        return this._active;
    }

    @Override
    protected int getBodySize() {
        int size = 1;
        return size;
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeBitfield(buffer, this._active ? (byte)1 : 0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchChannelFlowOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ChannelFlowOkBodyImpl: ");
        buf.append("active=");
        buf.append(this.getActive());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ChannelMethodProcessor dispatcher) throws IOException {
        boolean active;
        boolean bl = active = (buffer.readByte() & 1) == 1;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveChannelFlowOk(active);
        }
    }
}

