/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;

public class ConfirmSelectBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 85;
    public static final int METHOD_ID = 10;
    private final boolean _nowait;

    public ConfirmSelectBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._nowait = (buffer.readByte() & 1) == 1;
    }

    public ConfirmSelectBody(boolean nowait) {
        this._nowait = nowait;
    }

    @Override
    public int getClazz() {
        return 85;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    public final boolean getNowait() {
        return this._nowait;
    }

    @Override
    protected int getBodySize() {
        return 1;
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeBitfield(buffer, this._nowait ? (byte)1 : 0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConfirmSelect(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConfirmSelectBody: ");
        buf.append("active=");
        buf.append(this.getNowait());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ServerChannelMethodProcessor dispatcher) throws IOException {
        boolean nowait;
        boolean bl = nowait = (buffer.readByte() & 1) == 1;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveConfirmSelect(nowait);
        }
    }
}

