/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;

public class ExchangeDeclareBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 40;
    public static final int METHOD_ID = 10;
    private final int _ticket;
    private final AMQShortString _exchange;
    private final AMQShortString _type;
    private final byte _bitfield0;
    private final FieldTable _arguments;

    public ExchangeDeclareBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._ticket = buffer.readUnsignedShort();
        this._exchange = buffer.readAMQShortString();
        this._type = buffer.readAMQShortString();
        this._bitfield0 = buffer.readByte();
        this._arguments = EncodingUtils.readFieldTable(buffer);
    }

    public ExchangeDeclareBody(int ticket, AMQShortString exchange, AMQShortString type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, FieldTable arguments) {
        this._ticket = ticket;
        this._exchange = exchange;
        this._type = type;
        byte bitfield0 = 0;
        if (passive) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (durable) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (autoDelete) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        if (internal) {
            bitfield0 = (byte)(bitfield0 | 8);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 0x10);
        }
        this._bitfield0 = bitfield0;
        this._arguments = arguments;
    }

    @Override
    public int getClazz() {
        return 40;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getType() {
        return this._type;
    }

    public final boolean getPassive() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getDurable() {
        return (this._bitfield0 & 2) != 0;
    }

    public final boolean getAutoDelete() {
        return (this._bitfield0 & 4) != 0;
    }

    public final boolean getInternal() {
        return (this._bitfield0 & 8) != 0;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 0x10) != 0;
    }

    public final FieldTable getArguments() {
        return this._arguments;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._type);
        return size += this.getSizeOf(this._arguments);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._type);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeFieldTable(buffer, this._arguments);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchExchangeDeclare(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ExchangeDeclareBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("type=");
        buf.append(this.getType());
        buf.append(", ");
        buf.append("passive=");
        buf.append(this.getPassive());
        buf.append(", ");
        buf.append("durable=");
        buf.append(this.getDurable());
        buf.append(", ");
        buf.append("autoDelete=");
        buf.append(this.getAutoDelete());
        buf.append(", ");
        buf.append("internal=");
        buf.append(this.getInternal());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append(", ");
        buf.append("arguments=");
        buf.append(this.getArguments());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ServerChannelMethodProcessor dispatcher) throws IOException, AMQFrameDecodingException {
        int ticket = buffer.readUnsignedShort();
        AMQShortString exchange = buffer.readAMQShortString();
        AMQShortString type = buffer.readAMQShortString();
        byte bitfield = buffer.readByte();
        boolean passive = (bitfield & 1) == 1;
        boolean durable = (bitfield & 2) == 2;
        boolean autoDelete = (bitfield & 4) == 4;
        boolean internal = (bitfield & 8) == 8;
        boolean nowait = (bitfield & 0x10) == 16;
        FieldTable arguments = EncodingUtils.readFieldTable(buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveExchangeDeclare(exchange, type, passive, durable, autoDelete, internal, nowait, arguments);
        }
        if (arguments != null) {
            arguments.clearEncodedForm();
        }
    }
}

