/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.AccessRequestBody;
import org.apache.qpid.framing.AccessRequestOkBody;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicConsumeBody;
import org.apache.qpid.framing.BasicConsumeOkBody;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.BasicDeliverBody;
import org.apache.qpid.framing.BasicGetBody;
import org.apache.qpid.framing.BasicGetEmptyBody;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicNackBody;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.BasicQosBody;
import org.apache.qpid.framing.BasicQosOkBody;
import org.apache.qpid.framing.BasicRecoverBody;
import org.apache.qpid.framing.BasicRecoverSyncBody;
import org.apache.qpid.framing.BasicRecoverSyncOkBody;
import org.apache.qpid.framing.BasicRejectBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.ChannelAlertBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ChannelFlowBody;
import org.apache.qpid.framing.ChannelFlowOkBody;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.ClientChannelMethodProcessor;
import org.apache.qpid.framing.ClientMethodProcessor;
import org.apache.qpid.framing.ConfirmSelectBody;
import org.apache.qpid.framing.ConfirmSelectOkBody;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionCloseOkBody;
import org.apache.qpid.framing.ConnectionOpenBody;
import org.apache.qpid.framing.ConnectionOpenOkBody;
import org.apache.qpid.framing.ConnectionRedirectBody;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionSecureOkBody;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.ConnectionTuneOkBody;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.ExchangeBoundBody;
import org.apache.qpid.framing.ExchangeBoundOkBody;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.ExchangeDeclareOkBody;
import org.apache.qpid.framing.ExchangeDeleteBody;
import org.apache.qpid.framing.ExchangeDeleteOkBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.HeartbeatBody;
import org.apache.qpid.framing.MethodProcessor;
import org.apache.qpid.framing.ProtocolInitiation;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.QueueBindBody;
import org.apache.qpid.framing.QueueBindOkBody;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.framing.QueueDeleteBody;
import org.apache.qpid.framing.QueueDeleteOkBody;
import org.apache.qpid.framing.QueuePurgeBody;
import org.apache.qpid.framing.QueuePurgeOkBody;
import org.apache.qpid.framing.QueueUnbindBody;
import org.apache.qpid.framing.QueueUnbindOkBody;
import org.apache.qpid.framing.ServerChannelMethodProcessor;
import org.apache.qpid.framing.ServerMethodProcessor;
import org.apache.qpid.framing.TxCommitBody;
import org.apache.qpid.framing.TxCommitOkBody;
import org.apache.qpid.framing.TxRollbackBody;
import org.apache.qpid.framing.TxRollbackOkBody;
import org.apache.qpid.framing.TxSelectBody;
import org.apache.qpid.framing.TxSelectOkBody;

public class FrameCreatingMethodProcessor
implements MethodProcessor<ClientAndServerChannelMethodProcessor>,
ClientMethodProcessor<ClientAndServerChannelMethodProcessor>,
ServerMethodProcessor<ClientAndServerChannelMethodProcessor> {
    private ProtocolVersion _protocolVersion;
    private final List<AMQDataBlock> _processedMethods = new ArrayList<AMQDataBlock>();
    private int _classId;
    private int _methodId;

    public FrameCreatingMethodProcessor(ProtocolVersion protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    public List<AMQDataBlock> getProcessedMethods() {
        return this._processedMethods;
    }

    @Override
    public void receiveConnectionStart(short versionMajor, short versionMinor, FieldTable serverProperties, byte[] mechanisms, byte[] locales) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionStartBody(versionMajor, versionMinor, serverProperties, mechanisms, locales)));
    }

    @Override
    public void receiveConnectionStartOk(FieldTable clientProperties, AMQShortString mechanism, byte[] response, AMQShortString locale) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionStartOkBody(clientProperties, mechanism, response, locale)));
    }

    @Override
    public void receiveConnectionSecure(byte[] challenge) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionSecureBody(challenge)));
    }

    @Override
    public void receiveConnectionSecureOk(byte[] response) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionSecureOkBody(response)));
    }

    @Override
    public void receiveConnectionTune(int channelMax, long frameMax, int heartbeat) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionTuneBody(channelMax, frameMax, heartbeat)));
    }

    @Override
    public void receiveConnectionTuneOk(int channelMax, long frameMax, int heartbeat) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionTuneOkBody(channelMax, frameMax, heartbeat)));
    }

    @Override
    public void receiveConnectionOpen(AMQShortString virtualHost, AMQShortString capabilities, boolean insist) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionOpenBody(virtualHost, capabilities, insist)));
    }

    @Override
    public void receiveConnectionOpenOk(AMQShortString knownHosts) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionOpenOkBody(knownHosts)));
    }

    @Override
    public void receiveConnectionRedirect(AMQShortString host, AMQShortString knownHosts) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionRedirectBody(this.getProtocolVersion(), host, knownHosts)));
    }

    @Override
    public void receiveConnectionClose(int replyCode, AMQShortString replyText, int classId, int methodId) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionCloseBody(this.getProtocolVersion(), replyCode, replyText, classId, methodId)));
    }

    @Override
    public void receiveConnectionCloseOk() {
        this._processedMethods.add(new AMQFrame(0, ProtocolVersion.v0_8.equals(this.getProtocolVersion()) ? ConnectionCloseOkBody.CONNECTION_CLOSE_OK_0_8 : ConnectionCloseOkBody.CONNECTION_CLOSE_OK_0_9));
    }

    @Override
    public void receiveChannelOpen(int channelId) {
        this._processedMethods.add(new AMQFrame(channelId, new ChannelOpenBody()));
    }

    private void receiveExchangeBoundOk(int channelId, int replyCode, AMQShortString replyText) {
        this._processedMethods.add(new AMQFrame(channelId, new ExchangeBoundOkBody(replyCode, replyText)));
    }

    @Override
    public void receiveHeartbeat() {
        this._processedMethods.add(new AMQFrame(0, new HeartbeatBody()));
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }

    @Override
    public ClientAndServerChannelMethodProcessor getChannelMethodProcessor(int channelId) {
        return new FrameCreatingChannelMethodProcessor(channelId);
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    @Override
    public void receiveProtocolHeader(ProtocolInitiation protocolInitiation) {
        this._processedMethods.add(protocolInitiation);
    }

    @Override
    public void setCurrentMethod(int classId, int methodId) {
        this._classId = classId;
        this._methodId = methodId;
    }

    @Override
    public boolean ignoreAllButCloseOk() {
        return false;
    }

    public int getClassId() {
        return this._classId;
    }

    public int getMethodId() {
        return this._methodId;
    }

    private class FrameCreatingChannelMethodProcessor
    implements ClientAndServerChannelMethodProcessor {
        private final int _channelId;

        private FrameCreatingChannelMethodProcessor(int channelId) {
            this._channelId = channelId;
        }

        @Override
        public void receiveChannelOpenOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, ProtocolVersion.v0_8.equals(FrameCreatingMethodProcessor.this.getProtocolVersion()) ? ChannelOpenOkBody.INSTANCE_0_8 : ChannelOpenOkBody.INSTANCE_0_9));
        }

        @Override
        public void receiveChannelAlert(int replyCode, AMQShortString replyText, FieldTable details) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ChannelAlertBody(replyCode, replyText, details)));
        }

        @Override
        public void receiveAccessRequestOk(int ticket) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new AccessRequestOkBody(ticket)));
        }

        @Override
        public void receiveExchangeDeclareOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ExchangeDeclareOkBody()));
        }

        @Override
        public void receiveExchangeDeleteOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ExchangeDeleteOkBody()));
        }

        @Override
        public void receiveExchangeBoundOk(int replyCode, AMQShortString replyText) {
            FrameCreatingMethodProcessor.this.receiveExchangeBoundOk(this._channelId, replyCode, replyText);
        }

        @Override
        public void receiveQueueBindOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueBindOkBody()));
        }

        @Override
        public void receiveQueueUnbindOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueUnbindOkBody()));
        }

        @Override
        public void receiveQueueDeclareOk(AMQShortString queue, long messageCount, long consumerCount) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueDeclareOkBody(queue, messageCount, consumerCount)));
        }

        @Override
        public void receiveQueuePurgeOk(long messageCount) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueuePurgeOkBody(messageCount)));
        }

        @Override
        public void receiveQueueDeleteOk(long messageCount) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueDeleteOkBody(messageCount)));
        }

        @Override
        public void receiveBasicRecoverSyncOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicRecoverSyncOkBody(FrameCreatingMethodProcessor.this.getProtocolVersion())));
        }

        @Override
        public void receiveBasicQosOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicQosOkBody()));
        }

        @Override
        public void receiveBasicConsumeOk(AMQShortString consumerTag) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicConsumeOkBody(consumerTag)));
        }

        @Override
        public void receiveBasicCancelOk(AMQShortString consumerTag) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicCancelOkBody(consumerTag)));
        }

        @Override
        public void receiveBasicReturn(int replyCode, AMQShortString replyText, AMQShortString exchange, AMQShortString routingKey) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicReturnBody(replyCode, replyText, exchange, routingKey)));
        }

        @Override
        public void receiveBasicDeliver(AMQShortString consumerTag, long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicDeliverBody(consumerTag, deliveryTag, redelivered, exchange, routingKey)));
        }

        @Override
        public void receiveBasicGetOk(long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey, long messageCount) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicGetOkBody(deliveryTag, redelivered, exchange, routingKey, messageCount)));
        }

        @Override
        public void receiveBasicGetEmpty() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicGetEmptyBody((AMQShortString)null)));
        }

        @Override
        public void receiveTxSelectOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxSelectOkBody.INSTANCE));
        }

        @Override
        public void receiveTxCommitOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxCommitOkBody.INSTANCE));
        }

        @Override
        public void receiveTxRollbackOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxRollbackOkBody.INSTANCE));
        }

        @Override
        public void receiveConfirmSelectOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, ConfirmSelectOkBody.INSTANCE));
        }

        @Override
        public void receiveAccessRequest(AMQShortString realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new AccessRequestBody(realm, exclusive, passive, active, write, read)));
        }

        @Override
        public void receiveExchangeDeclare(AMQShortString exchange, AMQShortString type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, FieldTable arguments) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ExchangeDeclareBody(0, exchange, type, passive, durable, autoDelete, internal, nowait, arguments)));
        }

        @Override
        public void receiveExchangeDelete(AMQShortString exchange, boolean ifUnused, boolean nowait) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ExchangeDeleteBody(0, exchange, ifUnused, nowait)));
        }

        @Override
        public void receiveExchangeBound(AMQShortString exchange, AMQShortString routingKey, AMQShortString queue) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ExchangeBoundBody(exchange, routingKey, queue)));
        }

        @Override
        public void receiveQueueDeclare(AMQShortString queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean nowait, FieldTable arguments) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueDeclareBody(0, queue, passive, durable, exclusive, autoDelete, nowait, arguments)));
        }

        @Override
        public void receiveQueueBind(AMQShortString queue, AMQShortString exchange, AMQShortString bindingKey, boolean nowait, FieldTable arguments) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueBindBody(0, queue, exchange, bindingKey, nowait, arguments)));
        }

        @Override
        public void receiveQueuePurge(AMQShortString queue, boolean nowait) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueuePurgeBody(0, queue, nowait)));
        }

        @Override
        public void receiveQueueDelete(AMQShortString queue, boolean ifUnused, boolean ifEmpty, boolean nowait) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueDeleteBody(0, queue, ifUnused, ifEmpty, nowait)));
        }

        @Override
        public void receiveQueueUnbind(AMQShortString queue, AMQShortString exchange, AMQShortString bindingKey, FieldTable arguments) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueUnbindBody(0, queue, exchange, bindingKey, arguments)));
        }

        @Override
        public void receiveBasicRecover(boolean requeue, boolean sync) {
            if (ProtocolVersion.v0_8.equals(FrameCreatingMethodProcessor.this.getProtocolVersion()) || !sync) {
                FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicRecoverBody(requeue)));
            } else {
                FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicRecoverSyncBody(FrameCreatingMethodProcessor.this.getProtocolVersion(), requeue)));
            }
        }

        @Override
        public void receiveBasicQos(long prefetchSize, int prefetchCount, boolean global) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicQosBody(prefetchSize, prefetchCount, global)));
        }

        @Override
        public void receiveBasicConsume(AMQShortString queue, AMQShortString consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait, FieldTable arguments) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicConsumeBody(0, queue, consumerTag, noLocal, noAck, exclusive, nowait, arguments)));
        }

        @Override
        public void receiveBasicCancel(AMQShortString consumerTag, boolean noWait) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicCancelBody(consumerTag, noWait)));
        }

        @Override
        public void receiveBasicPublish(AMQShortString exchange, AMQShortString routingKey, boolean mandatory, boolean immediate) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicPublishBody(0, exchange, routingKey, mandatory, immediate)));
        }

        @Override
        public void receiveBasicGet(AMQShortString queue, boolean noAck) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicGetBody(0, queue, noAck)));
        }

        @Override
        public void receiveBasicAck(long deliveryTag, boolean multiple) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicAckBody(deliveryTag, multiple)));
        }

        @Override
        public void receiveBasicReject(long deliveryTag, boolean requeue) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicRejectBody(deliveryTag, requeue)));
        }

        @Override
        public void receiveTxSelect() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxSelectBody.INSTANCE));
        }

        @Override
        public void receiveTxCommit() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxCommitBody.INSTANCE));
        }

        @Override
        public void receiveTxRollback() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxRollbackBody.INSTANCE));
        }

        @Override
        public void receiveConfirmSelect(boolean nowait) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ConfirmSelectBody(nowait)));
        }

        @Override
        public void receiveChannelFlow(boolean active) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ChannelFlowBody(active)));
        }

        @Override
        public void receiveChannelFlowOk(boolean active) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ChannelFlowOkBody(active)));
        }

        @Override
        public void receiveChannelClose(int replyCode, AMQShortString replyText, int classId, int methodId) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ChannelCloseBody(replyCode, replyText, classId, methodId)));
        }

        @Override
        public void receiveChannelCloseOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, ChannelCloseOkBody.INSTANCE));
        }

        @Override
        public void receiveMessageContent(QpidByteBuffer data) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ContentBody(data)));
        }

        @Override
        public void receiveMessageHeader(BasicContentHeaderProperties properties, long bodySize) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ContentHeaderBody(properties, bodySize)));
        }

        @Override
        public boolean ignoreAllButCloseOk() {
            return false;
        }

        @Override
        public void receiveBasicNack(long deliveryTag, boolean multiple, boolean requeue) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicNackBody(deliveryTag, multiple, requeue)));
        }
    }

    public static interface ClientAndServerChannelMethodProcessor
    extends ServerChannelMethodProcessor,
    ClientChannelMethodProcessor {
    }
}

