/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.ClientChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.MethodDispatcher;

public class QueueDeleteOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 41;
    private final long _messageCount;

    public QueueDeleteOkBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._messageCount = EncodingUtils.readUnsignedInteger(buffer);
    }

    public QueueDeleteOkBody(long messageCount) {
        this._messageCount = messageCount;
    }

    @Override
    public int getClazz() {
        return 50;
    }

    @Override
    public int getMethod() {
        return 41;
    }

    public final long getMessageCount() {
        return this._messageCount;
    }

    @Override
    protected int getBodySize() {
        int size = 4;
        return size;
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedInteger(buffer, this._messageCount);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchQueueDeleteOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueDeleteOkBodyImpl: ");
        buf.append("messageCount=");
        buf.append(this.getMessageCount());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ClientChannelMethodProcessor dispatcher) throws IOException {
        long messageCount = EncodingUtils.readUnsignedInteger(buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveQueueDeleteOk(messageCount);
        }
    }
}

