/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.qpid.configuration.QpidProperty;
import org.apache.qpid.ssl.SSLContextFactory;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;

public class ConnectionSettings {
    public static final String WILDCARD_ADDRESS = "*";
    private static final SecureRandom RANDOM = new SecureRandom();
    private String protocol = "tcp";
    private String host = "localhost";
    private String vhost;
    private String username;
    private String password;
    private int port = 5672;
    private boolean tcpNodelay = QpidProperty.booleanProperty(Boolean.TRUE, "qpid.tcp_nodelay", "amqj.tcp_nodelay").get();
    private int maxChannelCount = Short.MAX_VALUE;
    private int maxFrameSize = 65535;
    private Integer hearbeatIntervalLegacyMs = QpidProperty.intProperty(null, "idle_timeout").get();
    private Integer heartbeatInterval = QpidProperty.intProperty(null, "qpid.heartbeat", "amqj.heartbeat.delay").get();
    private float heartbeatTimeoutFactor = QpidProperty.floatProperty(Float.valueOf(2.0f), "qpid.heartbeat_timeout_factor", "amqj.heartbeat.timeoutFactor").get().floatValue();
    private int connectTimeout = 30000;
    private int readBufferSize = QpidProperty.intProperty(65535, "qpid.receive_buffer_size", "amqj.receiveBufferSize").get();
    private int writeBufferSize = QpidProperty.intProperty(65535, "qpid.send_buffer_size", "amqj.sendBufferSize").get();
    private boolean useSSL;
    private String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
    private String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
    private String keyManagerFactoryAlgorithm = QpidProperty.stringProperty(KeyManagerFactory.getDefaultAlgorithm(), "qpid.ssl.KeyManagerFactory.algorithm", "qpid.ssl.keyStoreCertType").get();
    private String trustManagerFactoryAlgorithm = QpidProperty.stringProperty(TrustManagerFactory.getDefaultAlgorithm(), "qpid.ssl.TrustManagerFactory.algorithm", "qpid.ssl.trustStoreCertType").get();
    private String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
    private String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
    private String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
    private String certAlias;
    private boolean verifyHostname;
    private String _clientCertificatePrivateKeyPath;
    private String _clientCertificatePath;
    private String _clientCertificateIntermediateCertsPath;
    private String _trustedCertificatesFile;
    private String _encryptionKeyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private String _encryptionKeyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
    private String _encryptionKeyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
    private String _encryptionKeyManagerFactoryAlgorithm = QpidProperty.stringProperty(KeyManagerFactory.getDefaultAlgorithm(), "qpid.ssl.KeyManagerFactory.algorithm", "qpid.ssl.keyStoreCertType").get();
    private String _encryptionTrustManagerFactoryAlgorithm = QpidProperty.stringProperty(TrustManagerFactory.getDefaultAlgorithm(), "qpid.ssl.TrustManagerFactory.algorithm", "qpid.ssl.trustStoreCertType").get();
    private String _encryptionTrustStorePath = System.getProperty("javax.net.ssl.trustStore");
    private String _encryptionTrustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
    private String _encryptionTrustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
    private String _encryptionRemoteTrustStoreName;
    private String saslMechs = System.getProperty("qpid.sasl_mechs", null);
    private String saslProtocol = System.getProperty("qpid.sasl_protocol", "AMQP");
    private String saslServerName = System.getProperty("qpid.sasl_server_name", "localhost");
    private boolean useSASLEncryption;
    private Map<String, Object> _clientProperties;
    private KeyStore _encryptionTrustStore;
    private KeyStore _encryptionKeyStore;

    public boolean isTcpNodelay() {
        return this.tcpNodelay;
    }

    public void setTcpNodelay(boolean tcpNodelay) {
        this.tcpNodelay = tcpNodelay;
    }

    public Integer getHeartbeatInterval08() {
        if (this.heartbeatInterval != null) {
            return this.heartbeatInterval;
        }
        if (this.hearbeatIntervalLegacyMs != null) {
            return this.hearbeatIntervalLegacyMs / 1000;
        }
        return null;
    }

    public int getHeartbeatInterval010() {
        if (this.heartbeatInterval != null) {
            return this.heartbeatInterval;
        }
        if (this.hearbeatIntervalLegacyMs != null) {
            return this.hearbeatIntervalLegacyMs / 1000;
        }
        return 120;
    }

    public void setHeartbeatInterval(int heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public float getHeartbeatTimeoutFactor() {
        return this.heartbeatTimeoutFactor;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getVhost() {
        return this.vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public boolean isUseSASLEncryption() {
        return this.useSASLEncryption;
    }

    public void setUseSASLEncryption(boolean useSASLEncryption) {
        this.useSASLEncryption = useSASLEncryption;
    }

    public String getSaslMechs() {
        return this.saslMechs;
    }

    public void setSaslMechs(String saslMechs) {
        this.saslMechs = saslMechs;
    }

    public String getSaslProtocol() {
        return this.saslProtocol;
    }

    public void setSaslProtocol(String saslProtocol) {
        this.saslProtocol = saslProtocol;
    }

    public String getSaslServerName() {
        return this.saslServerName;
    }

    public void setSaslServerName(String saslServerName) {
        this.saslServerName = saslServerName;
    }

    public int getMaxChannelCount() {
        return this.maxChannelCount;
    }

    public void setMaxChannelCount(int maxChannelCount) {
        this.maxChannelCount = maxChannelCount;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this._clientProperties = clientProperties;
    }

    public Map<String, Object> getClientProperties() {
        return this._clientProperties;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    public void setVerifyHostname(boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this.keyManagerFactoryAlgorithm;
    }

    public void setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
        this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this.trustManagerFactoryAlgorithm;
    }

    public void setTrustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
        this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getClientCertificatePrivateKeyPath() {
        return this._clientCertificatePrivateKeyPath;
    }

    public void setClientCertificatePrivateKeyPath(String clientCertificatePrivateKeyPath) {
        this._clientCertificatePrivateKeyPath = clientCertificatePrivateKeyPath;
    }

    public String getClientCertificatePath() {
        return this._clientCertificatePath;
    }

    public void setClientCertificatePath(String clientCertificatePath) {
        this._clientCertificatePath = clientCertificatePath;
    }

    public String getClientCertificateIntermediateCertsPath() {
        return this._clientCertificateIntermediateCertsPath;
    }

    public void setClientCertificateIntermediateCertsPath(String clientCertificateIntermediateCertsPath) {
        this._clientCertificateIntermediateCertsPath = clientCertificateIntermediateCertsPath;
    }

    public String getTrustedCertificatesFile() {
        return this._trustedCertificatesFile;
    }

    public void setTrustedCertificatesFile(String trustedCertificatesFile) {
        this._trustedCertificatesFile = trustedCertificatesFile;
    }

    public String getEncryptionKeyStorePath() {
        return this._encryptionKeyStorePath;
    }

    public void setEncryptionKeyStorePath(String encryptionKeyStorePath) {
        this._encryptionKeyStorePath = encryptionKeyStorePath;
    }

    public String getEncryptionKeyStorePassword() {
        return this._encryptionKeyStorePassword;
    }

    public void setEncryptionKeyStorePassword(String encryptionKeyStorePassword) {
        this._encryptionKeyStorePassword = encryptionKeyStorePassword;
    }

    public String getEncryptionKeyStoreType() {
        return this._encryptionKeyStoreType;
    }

    public void setEncryptionKeyStoreType(String encryptionKeyStoreType) {
        this._encryptionKeyStoreType = encryptionKeyStoreType;
    }

    public String getEncryptionKeyManagerFactoryAlgorithm() {
        return this._encryptionKeyManagerFactoryAlgorithm;
    }

    public void setEncryptionKeyManagerFactoryAlgorithm(String encryptionKeyManagerFactoryAlgorithm) {
        this._encryptionKeyManagerFactoryAlgorithm = encryptionKeyManagerFactoryAlgorithm;
    }

    public String getEncryptionTrustManagerFactoryAlgorithm() {
        return this._encryptionTrustManagerFactoryAlgorithm;
    }

    public void setEncryptionTrustManagerFactoryAlgorithm(String encryptionTrustManagerFactoryAlgorithm) {
        this._encryptionTrustManagerFactoryAlgorithm = encryptionTrustManagerFactoryAlgorithm;
    }

    public String getEncryptionTrustStorePath() {
        return this._encryptionTrustStorePath;
    }

    public void setEncryptionTrustStorePath(String encryptionTrustStorePath) {
        this._encryptionTrustStorePath = encryptionTrustStorePath;
    }

    public String getEncryptionTrustStorePassword() {
        return this._encryptionTrustStorePassword;
    }

    public void setEncryptionTrustStorePassword(String encryptionTrustStorePassword) {
        this._encryptionTrustStorePassword = encryptionTrustStorePassword;
    }

    public String getEncryptionTrustStoreType() {
        return this._encryptionTrustStoreType;
    }

    public void setEncryptionTrustStoreType(String encryptionTrustStoreType) {
        this._encryptionTrustStoreType = encryptionTrustStoreType;
    }

    public String getEncryptionRemoteTrustStoreName() {
        return this._encryptionRemoteTrustStoreName;
    }

    public void setEncryptionRemoteTrustStoreName(String encryptionRemoteTrustStoreName) {
        this._encryptionRemoteTrustStoreName = encryptionRemoteTrustStoreName;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public KeyManager[] getKeyManagers() throws GeneralSecurityException, IOException {
        if (this.getKeyStorePath() != null) {
            return SSLContextFactory.getKeyManagers(this.getKeyStorePath(), this.getKeyStorePassword(), this.getKeyStoreType(), this.getKeyManagerFactoryAlgorithm(), this.getCertAlias());
        }
        if (this.getClientCertificatePrivateKeyPath() != null) {
            return this.getKeyManagers(this.getClientCertificatePrivateKeyPath(), this.getClientCertificatePath(), this.getClientCertificateIntermediateCertsPath(), this.getKeyManagerFactoryAlgorithm());
        }
        return null;
    }

    public TrustManager[] getTrustManagers() throws GeneralSecurityException, IOException {
        if (this.getTrustStorePath() != null) {
            return SSLContextFactory.getTrustManagers(this.getTrustStorePath(), this.getTrustStorePassword(), this.getTrustStoreType(), this.getTrustManagerFactoryAlgorithm());
        }
        if (this.getTrustedCertificatesFile() != null) {
            return this.getTrustManagers(this.getTrustedCertificatesFile());
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private KeyManager[] getKeyManagers(String privateKeyFile, String certFile, String intermediateFile, String keyManagerFactoryAlgorithm) throws GeneralSecurityException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TrustManager[] getTrustManagers(String certFile) throws GeneralSecurityException, IOException {
        try (FileInputStream input = new FileInputStream(certFile);){
            X509Certificate[] certs = SSLUtil.readCertificates(input);
            KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inMemoryKeyStore.load(null, null);
            int i = 1;
            for (X509Certificate cert : certs) {
                inMemoryKeyStore.setCertificateEntry(String.valueOf(i++), cert);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(inMemoryKeyStore);
            TrustManager[] trustManagerArray = tmf.getTrustManagers();
            return trustManagerArray;
        }
    }

    public synchronized KeyStore getEncryptionTrustStore(RemoteStoreFinder storeFinder) throws GeneralSecurityException, IOException {
        if (this._encryptionTrustStore == null) {
            if (this._encryptionTrustStorePath != null) {
                this._encryptionTrustStore = SSLUtil.getInitializedKeyStore(this.getEncryptionTrustStorePath(), this.getEncryptionTrustStorePassword(), this.getEncryptionTrustStoreType());
            } else if (this._encryptionRemoteTrustStoreName != null) {
                return storeFinder.getKeyStore(this._encryptionRemoteTrustStoreName);
            }
        }
        return this._encryptionTrustStore;
    }

    public synchronized KeyStore getEncryptionKeyStore() throws GeneralSecurityException, IOException {
        if (this._encryptionKeyStore == null && this._encryptionKeyStorePath != null) {
            this._encryptionKeyStore = SSLUtil.getInitializedKeyStore(this.getEncryptionKeyStorePath(), this.getEncryptionKeyStorePassword(), this.getEncryptionKeyStoreType());
        }
        return this._encryptionKeyStore;
    }

    public static interface RemoteStoreFinder {
        public KeyStore getKeyStore(String var1) throws GeneralSecurityException, IOException;
    }
}

