/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.filter;

import java.util.HashMap;
import org.apache.qpid.filter.Expression;
import org.apache.qpid.filter.FilterableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyExpression
implements Expression {
    private static final int DEFAULT_PRIORITY = 4;
    private static final Logger _logger = LoggerFactory.getLogger(PropertyExpression.class);
    private static final HashMap<String, Expression> JMS_PROPERTY_EXPRESSIONS = new HashMap();
    private final String name;
    private final Expression jmsPropertyExpression;

    public boolean outerTest() {
        return false;
    }

    public PropertyExpression(String name) {
        this.name = name;
        this.jmsPropertyExpression = JMS_PROPERTY_EXPRESSIONS.get(name);
    }

    @Override
    public Object evaluate(FilterableMessage message) {
        if (this.jmsPropertyExpression != null) {
            return this.jmsPropertyExpression.evaluate(message);
        }
        return message.getHeader(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.name.equals(((PropertyExpression)o).name);
    }

    static {
        JMS_PROPERTY_EXPRESSIONS.put("JMSDestination", new Expression(){

            @Override
            public Object evaluate(FilterableMessage message) {
                return null;
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSReplyTo", new ReplyToExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSType", new TypeExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSDeliveryMode", new DeliveryModeExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSPriority", new PriorityExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSMessageID", new MessageIDExpression());
        JMS_PROPERTY_EXPRESSIONS.put("AMQMessageID", new MessageIDExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSTimestamp", new TimestampExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSCorrelationID", new CorrelationIdExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSExpiration", new ExpirationExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSRedelivered", new Expression(){

            @Override
            public Object evaluate(FilterableMessage message) {
                return message.isRedelivered();
            }
        });
    }

    private static class ExpirationExpression
    implements Expression {
        private ExpirationExpression() {
        }

        @Override
        public Object evaluate(FilterableMessage message) {
            long expiration = message.getExpiration();
            return expiration;
        }
    }

    private static class CorrelationIdExpression
    implements Expression {
        private CorrelationIdExpression() {
        }

        @Override
        public Object evaluate(FilterableMessage message) {
            String correlationId = message.getCorrelationId();
            return correlationId;
        }
    }

    private static class TimestampExpression
    implements Expression {
        private TimestampExpression() {
        }

        @Override
        public Object evaluate(FilterableMessage message) {
            long timestamp = message.getTimestamp();
            return timestamp;
        }
    }

    private static class MessageIDExpression
    implements Expression {
        private MessageIDExpression() {
        }

        @Override
        public Object evaluate(FilterableMessage message) {
            String messageId = message.getMessageId();
            return messageId;
        }
    }

    private static class PriorityExpression
    implements Expression {
        private PriorityExpression() {
        }

        @Override
        public Object evaluate(FilterableMessage message) {
            byte priority = message.getPriority();
            return (int)priority;
        }
    }

    private static class DeliveryModeExpression
    implements Expression {
        private DeliveryModeExpression() {
        }

        @Override
        public Object evaluate(FilterableMessage message) {
            JMSDeliveryMode mode;
            JMSDeliveryMode jMSDeliveryMode = mode = message.isPersistent() ? JMSDeliveryMode.PERSISTENT : JMSDeliveryMode.NON_PERSISTENT;
            if (_logger.isDebugEnabled()) {
                _logger.debug("JMSDeliveryMode is :" + (Object)((Object)mode));
            }
            return mode.toString();
        }
    }

    private static class TypeExpression
    implements Expression {
        private TypeExpression() {
        }

        @Override
        public Object evaluate(FilterableMessage message) {
            String type = message.getType();
            return type;
        }
    }

    private static class ReplyToExpression
    implements Expression {
        private ReplyToExpression() {
        }

        @Override
        public Object evaluate(FilterableMessage message) {
            String replyTo = message.getReplyTo();
            return replyTo;
        }
    }

    private static enum JMSDeliveryMode {
        NON_PERSISTENT,
        PERSISTENT;

    }
}

