/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQShortString;

public class ByteBufferListDataInput
implements MarkableDataInput {
    private final List<ByteBuffer> _underlying;
    private int _bufferIndex;
    private int _mark;

    public ByteBufferListDataInput(List<ByteBuffer> underlying) {
        this._underlying = underlying;
    }

    @Override
    public void readFully(byte[] b) {
        ByteBuffer currentBuffer = this.getCurrentBuffer();
        if (currentBuffer.remaining() > b.length) {
            currentBuffer.get(b);
        } else {
            ByteBuffer buf = this.readAsNativeByteBuffer(b.length);
            buf.get(b);
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        ByteBuffer currentBuffer = this.getCurrentBuffer();
        if (currentBuffer.remaining() > len) {
            currentBuffer.get(b, off, len);
        } else {
            ByteBuffer buf = this.readAsNativeByteBuffer(len);
            buf.get(b, off, len);
        }
    }

    @Override
    public QpidByteBuffer readAsByteBuffer(int len) {
        return QpidByteBuffer.wrap(this.readAsNativeByteBuffer(len));
    }

    private ByteBuffer readAsNativeByteBuffer(int len) {
        ByteBuffer dest;
        ByteBuffer currentBuffer = this.getCurrentBuffer();
        if (currentBuffer.remaining() >= len) {
            ByteBuffer buf = currentBuffer.slice();
            buf.limit(len);
            currentBuffer.position(currentBuffer.position() + len);
            return buf;
        }
        ByteBuffer byteBuffer = dest = currentBuffer.isDirect() ? ByteBuffer.allocateDirect(len) : ByteBuffer.allocate(len);
        while (dest.hasRemaining() && this.available() > 0) {
            this.advanceIfNecessary();
            currentBuffer = this.getCurrentBuffer();
            int remaining = dest.remaining();
            if (currentBuffer.remaining() >= remaining) {
                ByteBuffer buf = currentBuffer.slice();
                buf.limit(remaining);
                currentBuffer.position(currentBuffer.position() + remaining);
                dest.put(buf);
                continue;
            }
            dest.put(currentBuffer);
        }
        dest.flip();
        return dest;
    }

    @Override
    public int skipBytes(int n) {
        ByteBuffer currentBuffer = this.getCurrentBuffer();
        if (currentBuffer.remaining() > n) {
            currentBuffer.position(currentBuffer.position() + n);
        } else {
            n -= currentBuffer.remaining();
            currentBuffer.position(currentBuffer.limit());
            if (this._bufferIndex != this._underlying.size() - 1) {
                ++this._bufferIndex;
                this.skipBytes(n);
            }
        }
        return this.position();
    }

    private ByteBuffer getCurrentBuffer() {
        return this._underlying.get(this._bufferIndex);
    }

    @Override
    public boolean readBoolean() {
        this.advanceIfNecessary();
        return this.getCurrentBuffer().get() != 0;
    }

    private void advanceIfNecessary() {
        while (!this.getCurrentBuffer().hasRemaining() && this._bufferIndex != this._underlying.size() - 1) {
            ++this._bufferIndex;
        }
    }

    @Override
    public byte readByte() {
        this.advanceIfNecessary();
        return this.getCurrentBuffer().get();
    }

    @Override
    public int readUnsignedByte() {
        this.advanceIfNecessary();
        return this.getCurrentBuffer().get() & 0xFF;
    }

    @Override
    public short readShort() {
        return this.getBuffer(2).getShort();
    }

    private ByteBuffer getBuffer(int size) {
        this.advanceIfNecessary();
        ByteBuffer currentBuffer = this.getCurrentBuffer();
        if (currentBuffer.remaining() >= size) {
            return currentBuffer;
        }
        return this.readAsNativeByteBuffer(size);
    }

    @Override
    public int readUnsignedShort() {
        return this.getBuffer(2).getShort() & 0xFFFF;
    }

    @Override
    public char readChar() {
        return this.getBuffer(2).getChar();
    }

    @Override
    public int readInt() {
        return this.getBuffer(4).getInt();
    }

    @Override
    public long readLong() {
        return this.getBuffer(8).getLong();
    }

    @Override
    public float readFloat() {
        return this.getBuffer(4).getFloat();
    }

    @Override
    public double readDouble() {
        return this.getBuffer(8).getDouble();
    }

    @Override
    public AMQShortString readAMQShortString() {
        this.advanceIfNecessary();
        ByteBuffer currentBuffer = this.getCurrentBuffer();
        int size = currentBuffer.get(currentBuffer.position()) & 0xFF;
        return AMQShortString.readAMQShortString(this.getBuffer(size + 1));
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() {
        int remaining = 0;
        for (int i = this._bufferIndex; i < this._underlying.size(); ++i) {
            remaining += this._underlying.get(i).remaining();
        }
        return remaining;
    }

    @Override
    public long skip(long i) {
        this.skipBytes((int)i);
        return i;
    }

    @Override
    public int read(byte[] b) {
        this.readFully(b);
        return b.length;
    }

    public int position() {
        int position = 0;
        for (int i = 0; i < this._bufferIndex; ++i) {
            position += this._underlying.get(i).limit();
        }
        return position += this.getCurrentBuffer().position();
    }

    public void position(int position) {
        int offset = 0;
        boolean beforePos = true;
        for (int i = 0; i < this._underlying.size(); ++i) {
            ByteBuffer buffer = this._underlying.get(i);
            if (beforePos) {
                if (position - offset <= buffer.limit()) {
                    buffer.position(position - offset);
                    this._bufferIndex = i;
                    beforePos = false;
                    continue;
                }
                offset += buffer.limit();
                continue;
            }
            buffer.position(0);
        }
    }

    public int length() {
        int length = 0;
        for (ByteBuffer buf : this._underlying) {
            length += buf.limit();
        }
        return length;
    }

    @Override
    public void mark(int readAhead) {
        this._mark = this.position();
    }

    @Override
    public void reset() {
        this.position(this._mark);
    }
}

