/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.ChannelMethodProcessor;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.transport.ByteBufferSender;

public class ContentBody
implements AMQBody {
    public static final byte TYPE = 3;
    private QpidByteBuffer _payload;

    public ContentBody(ByteBuffer payload) {
        this._payload = QpidByteBuffer.wrap(payload.duplicate());
    }

    public ContentBody(QpidByteBuffer payload) {
        this._payload = payload.duplicate();
    }

    @Override
    public byte getFrameType() {
        return 3;
    }

    @Override
    public int getSize() {
        return this._payload == null ? 0 : this._payload.remaining();
    }

    @Override
    public void writePayload(DataOutput buffer) throws IOException {
        if (this._payload.hasArray()) {
            int start = this._payload.arrayOffset() + this._payload.position();
            buffer.write(this._payload.array(), start, this._payload.remaining());
            this._payload.position(this._payload.position() + this._payload.remaining());
        } else {
            byte[] data = new byte[this._payload.remaining()];
            this._payload.copyTo(data);
            buffer.write(data);
        }
    }

    @Override
    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws QpidException {
        session.contentBodyReceived(channelId, this);
    }

    @Override
    public long writePayload(ByteBufferSender sender) throws IOException {
        if (this._payload != null) {
            QpidByteBuffer duplicate = this._payload.duplicate();
            sender.send(duplicate);
            duplicate.dispose();
            return this._payload.remaining();
        }
        return 0L;
    }

    public QpidByteBuffer getPayload() {
        return this._payload;
    }

    public void dispose() {
        if (this._payload != null) {
            this._payload.dispose();
            this._payload = null;
        }
    }

    public static void process(MarkableDataInput in, ChannelMethodProcessor methodProcessor, long bodySize) throws IOException {
        QpidByteBuffer payload = in.readAsByteBuffer((int)bodySize);
        if (!methodProcessor.ignoreAllButCloseOk()) {
            methodProcessor.receiveMessageContent(payload);
        }
        payload.dispose();
    }

    public static AMQFrame createAMQFrame(int channelId, ContentBody body) {
        return new AMQFrame(channelId, body);
    }
}

