/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;

public class ExchangeDeleteBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 40;
    public static final int METHOD_ID = 20;
    private final int _ticket;
    private final AMQShortString _exchange;
    private final byte _bitfield0;

    public ExchangeDeleteBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._ticket = buffer.readUnsignedShort();
        this._exchange = buffer.readAMQShortString();
        this._bitfield0 = buffer.readByte();
    }

    public ExchangeDeleteBody(int ticket, AMQShortString exchange, boolean ifUnused, boolean nowait) {
        this._ticket = ticket;
        this._exchange = exchange;
        byte bitfield0 = 0;
        if (ifUnused) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 40;
    }

    @Override
    public int getMethod() {
        return 20;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final boolean getIfUnused() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        return size += this.getSizeOf(this._exchange);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchExchangeDelete(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ExchangeDeleteBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("ifUnused=");
        buf.append(this.getIfUnused());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ServerChannelMethodProcessor dispatcher) throws IOException {
        boolean nowait;
        int ticket = buffer.readUnsignedShort();
        AMQShortString exchange = buffer.readAMQShortString();
        byte bitfield = buffer.readByte();
        boolean ifUnused = (bitfield & 1) == 1;
        boolean bl = nowait = (bitfield & 2) == 2;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveExchangeDelete(exchange, ifUnused, nowait);
        }
    }
}

