/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocket;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.thread.Threading;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.SenderClosedException;
import org.apache.qpid.transport.SenderException;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.io.IoReceiver;
import org.apache.qpid.transport.util.Functions;
import org.apache.qpid.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IoSender
implements Runnable,
ByteBufferSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoSender.class);
    private static final int START = 0x7FFFFFF5;
    private final long timeout;
    private final Socket socket;
    private final OutputStream out;
    private final byte[] buffer;
    private volatile int head = 0x7FFFFFF5;
    private volatile int tail = 0x7FFFFFF5;
    private volatile boolean idle = true;
    private final Object notFull = new Object();
    private final Object notEmpty = new Object();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Thread senderThread;
    private IoReceiver _receiver;
    private final String _socketEndpointDescription;
    private static final boolean shutdownBroken = SystemUtils.isWindows();
    private volatile Throwable exception = null;

    public IoSender(Socket socket, int bufferSize, long timeout) {
        this.socket = socket;
        this.buffer = new byte[IoSender.pof2(bufferSize)];
        this.timeout = timeout;
        this._socketEndpointDescription = String.format("%s-%s", socket.getLocalSocketAddress(), socket.getRemoteSocketAddress());
        try {
            this.out = socket.getOutputStream();
        }
        catch (IOException e) {
            throw new TransportException("Error getting output stream for socket", e);
        }
        try {
            this.senderThread = Threading.getThreadFactory().createThread(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating IOSender thread", e);
        }
        this.senderThread.setDaemon(true);
        this.senderThread.setName(String.format("IoSndr-%s", this._socketEndpointDescription));
    }

    public void initiate() {
        this.senderThread.start();
    }

    private static final int pof2(int n) {
        int result;
        for (result = 1; result < n; result *= 2) {
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(QpidByteBuffer buf) {
        this.checkNotAlreadyClosed();
        if (!this.senderThread.isAlive()) {
            throw new SenderException(String.format("sender thread for socket %s is not alive", this._socketEndpointDescription));
        }
        int size = this.buffer.length;
        int remaining = buf.remaining();
        while (remaining > 0) {
            int hd = this.head;
            int tl = this.tail;
            if (hd - tl >= size) {
                this.flush();
                Object object = this.notFull;
                synchronized (object) {
                    long start = System.currentTimeMillis();
                    long elapsed = 0L;
                    while (!this.closed.get() && this.head - this.tail >= size && elapsed < this.timeout) {
                        try {
                            this.notFull.wait(this.timeout - elapsed);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        elapsed = System.currentTimeMillis() - start;
                    }
                    this.checkNotAlreadyClosed();
                    if (this.head - this.tail >= size) {
                        try {
                            LOGGER.error("write timed out for socket {}: head {}, tail {}", new Object[]{this._socketEndpointDescription, this.head, this.tail});
                            throw new SenderException(String.format("write timed out for socket %s: head %d, tail %d", this._socketEndpointDescription, this.head, this.tail));
                        }
                        catch (Throwable throwable) {
                            this.close(false, false);
                            throw throwable;
                        }
                    }
                    continue;
                }
            }
            int hd_idx = Functions.mod(hd, size);
            int tl_idx = Functions.mod(tl, size);
            int length = tl_idx > hd_idx ? Math.min(tl_idx - hd_idx, remaining) : Math.min(size - hd_idx, remaining);
            buf.get(this.buffer, hd_idx, length);
            this.head += length;
            remaining -= length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this.idle) {
            Object object = this.notEmpty;
            synchronized (object) {
                this.notEmpty.notify();
            }
        }
    }

    @Override
    public void close() {
        this.close(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean awaitSenderBeforeClose, boolean reportException) {
        if (!this.closed.getAndSet(true)) {
            Object object = this.notFull;
            synchronized (object) {
                this.notFull.notify();
            }
            object = this.notEmpty;
            synchronized (object) {
                this.notEmpty.notify();
            }
            try {
                if (awaitSenderBeforeClose) {
                    this.awaitSenderThreadShutdown();
                }
            }
            finally {
                this.closeReceiver();
            }
            if (reportException && this.exception != null) {
                throw new SenderException(this.exception);
            }
        }
    }

    private void closeReceiver() {
        if (this._receiver != null) {
            try {
                this._receiver.close();
            }
            catch (RuntimeException e) {
                LOGGER.error("Exception closing receiver for socket {}", (Object)this._socketEndpointDescription, (Object)e);
                throw new SenderException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int size = this.buffer.length;
        while (true) {
            int tl;
            int hd;
            if ((hd = this.head) == (tl = this.tail)) {
                if (this.closed.get()) break;
                this.idle = true;
                Object object = this.notEmpty;
                synchronized (object) {
                    while (this.head == this.tail && !this.closed.get()) {
                        try {
                            this.notEmpty.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.idle = false;
                continue;
            }
            int hd_idx = Functions.mod(hd, size);
            int tl_idx = Functions.mod(tl, size);
            int length = tl_idx < hd_idx ? hd_idx - tl_idx : size - tl_idx;
            try {
                this.out.write(this.buffer, tl_idx, length);
            }
            catch (IOException e) {
                LOGGER.info("Exception in thread sending for socket '{}' : {}", (Object)this._socketEndpointDescription, (Object)e.getMessage());
                this.exception = e;
                this.close(false, false);
                break;
            }
            this.tail += length;
            if (this.head - tl < size) continue;
            Object object = this.notFull;
            synchronized (object) {
                this.notFull.notify();
            }
        }
        if (!shutdownBroken && !(this.socket instanceof SSLSocket)) {
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setReceiver(IoReceiver receiver) {
        this._receiver = receiver;
    }

    private void awaitSenderThreadShutdown() {
        if (Thread.currentThread() != this.senderThread) {
            try {
                this.senderThread.join(this.timeout);
                if (this.senderThread.isAlive()) {
                    LOGGER.error("join timed out for socket {} to stop", (Object)this._socketEndpointDescription);
                    throw new SenderException(String.format("join timed out for socket %s to stop", this._socketEndpointDescription));
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("interrupted whilst waiting for sender thread for socket {} to stop", (Object)this._socketEndpointDescription);
                throw new SenderException(e);
            }
        }
    }

    private void checkNotAlreadyClosed() {
        if (this.closed.get()) {
            throw new SenderClosedException(String.format("sender for socket %s is closed", this._socketEndpointDescription), this.exception);
        }
    }
}

