/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.util;

import java.io.DataOutput;
import java.nio.ByteBuffer;

public class ByteBufferDataOutput
implements DataOutput {
    private final ByteBuffer _buf;

    public ByteBufferDataOutput(ByteBuffer buf) {
        this._buf = buf;
    }

    @Override
    public void write(int b) {
        this._buf.put((byte)b);
    }

    @Override
    public void write(byte[] b) {
        this._buf.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this._buf.put(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        this._buf.put(v ? (byte)1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this._buf.put((byte)v);
    }

    @Override
    public void writeShort(int v) {
        this._buf.putShort((short)v);
    }

    @Override
    public void writeChar(int v) {
        this._buf.put((byte)(v >>> 8));
        this._buf.put((byte)v);
    }

    @Override
    public void writeInt(int v) {
        this._buf.putInt(v);
    }

    @Override
    public void writeLong(long v) {
        this._buf.putLong(v);
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) {
        throw new UnsupportedOperationException("writeBytes(String s) not supported");
    }

    @Override
    public void writeChars(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this._buf.put((byte)(v >>> 8));
            this._buf.put((byte)v);
        }
    }

    @Override
    public void writeUTF(String s) {
        int strlen = s.length();
        int pos = this._buf.position();
        this._buf.position(pos + 2);
        for (int i = 0; i < strlen; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                c = s.charAt(i);
                this._buf.put((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this._buf.put((byte)(0xE0 | c >> 12 & 0xF));
                this._buf.put((byte)(0x80 | c >> 6 & 0x3F));
                this._buf.put((byte)(0x80 | c & 0x3F));
                continue;
            }
            this._buf.put((byte)(0xC0 | c >> 6 & 0x1F));
            this._buf.put((byte)(0x80 | c & 0x3F));
        }
        int len = this._buf.position() - (pos + 2);
        this._buf.put(pos++, (byte)(len >>> 8));
        this._buf.put(pos, (byte)len);
    }
}

