/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/*
 * This file is auto-generated by Qpid Gentools v.0.1 - do not modify.
 * Supported AMQP version:
 *   8-0
 */

package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;

import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;

public class BasicReturnBody extends AMQMethodBodyImpl implements EncodableAMQDataBlock, AMQMethodBody
{

    public static final int CLASS_ID =  60;
    public static final int METHOD_ID = 50;

    // Fields declared in specification
    private final int _replyCode; // [replyCode]
    private final AMQShortString _replyText; // [replyText]
    private final AMQShortString _exchange; // [exchange]
    private final AMQShortString _routingKey; // [routingKey]

    // Constructor
    public BasicReturnBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException
    {
        _replyCode = buffer.readUnsignedShort();
        _replyText = buffer.readAMQShortString();
        _exchange = buffer.readAMQShortString();
        _routingKey = buffer.readAMQShortString();
    }

    public BasicReturnBody(
            int replyCode,
            AMQShortString replyText,
            AMQShortString exchange,
            AMQShortString routingKey
                          )
    {
        _replyCode = replyCode;
        _replyText = replyText;
        _exchange = exchange;
        _routingKey = routingKey;
    }

    public int getClazz()
    {
        return CLASS_ID;
    }

    public int getMethod()
    {
        return METHOD_ID;
    }

    public final int getReplyCode()
    {
        return _replyCode;
    }
    public final AMQShortString getReplyText()
    {
        return _replyText;
    }
    public final AMQShortString getExchange()
    {
        return _exchange;
    }
    public final AMQShortString getRoutingKey()
    {
        return _routingKey;
    }

    protected int getBodySize()
    {
        int size = 2;
        size += getSizeOf( _replyText );
        size += getSizeOf( _exchange );
        size += getSizeOf( _routingKey );
        return size;
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException
    {
        writeUnsignedShort( buffer, _replyCode );
        writeAMQShortString( buffer, _replyText );
        writeAMQShortString( buffer, _exchange );
        writeAMQShortString( buffer, _routingKey );
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException
	{
        return dispatcher.dispatchBasicReturn(this, channelId);
	}

    public String toString()
    {
        StringBuilder buf = new StringBuilder("[BasicReturnBodyImpl: ");
        buf.append( "replyCode=" );
        buf.append(  getReplyCode() );
        buf.append( ", " );
        buf.append( "replyText=" );
        buf.append(  getReplyText() );
        buf.append( ", " );
        buf.append( "exchange=" );
        buf.append(  getExchange() );
        buf.append( ", " );
        buf.append( "routingKey=" );
        buf.append(  getRoutingKey() );
        buf.append("]");
        return buf.toString();
    }

    public static void process(final MarkableDataInput buffer,
                               final ClientChannelMethodProcessor dispatcher) throws IOException
    {

        int replyCode = buffer.readUnsignedShort();
        AMQShortString replyText = buffer.readAMQShortString();
        AMQShortString exchange = buffer.readAMQShortString();
        AMQShortString routingKey = buffer.readAMQShortString();
        if(!dispatcher.ignoreAllButCloseOk())
        {
            dispatcher.receiveBasicReturn(replyCode, replyText, exchange, routingKey);
        }
    }
}
