/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.streams.CompositeInputStream;

public class QpidByteBufferInputStream
extends InputStream {
    private final CompositeInputStream _compositeInputStream;
    private final Collection<QpidByteBuffer> _buffers;

    public QpidByteBufferInputStream(Collection<QpidByteBuffer> buffers) {
        this._buffers = buffers;
        ArrayList<InputStream> streams = new ArrayList<InputStream>(buffers.size());
        for (QpidByteBuffer buffer : buffers) {
            streams.add(buffer.asInputStream());
        }
        this._compositeInputStream = new CompositeInputStream(streams);
    }

    @Override
    public int read() throws IOException {
        return this._compositeInputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this._compositeInputStream.read(b, off, len);
    }

    @Override
    public void mark(int readlimit) {
        this._compositeInputStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this._compositeInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this._compositeInputStream.markSupported();
    }

    @Override
    public long skip(long n) throws IOException {
        return this._compositeInputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this._compositeInputStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this._compositeInputStream.close();
        }
        finally {
            for (QpidByteBuffer buffer : this._buffers) {
                buffer.dispose();
            }
        }
    }
}

