/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ClientMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;

public class ConnectionOpenOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 41;
    private final AMQShortString _knownHosts;

    public ConnectionOpenOkBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._knownHosts = buffer.readAMQShortString();
    }

    public ConnectionOpenOkBody(AMQShortString knownHosts) {
        this._knownHosts = knownHosts;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 41;
    }

    public final AMQShortString getKnownHosts() {
        return this._knownHosts;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._knownHosts);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._knownHosts);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConnectionOpenOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionOpenOkBodyImpl: ");
        buf.append("knownHosts=");
        buf.append(this.getKnownHosts());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ClientMethodProcessor dispatcher) throws IOException {
        AMQShortString knownHosts = buffer.readAMQShortString();
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveConnectionOpenOk(knownHosts);
        }
    }
}

