/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ChannelMethodProcessor;
import org.apache.qpid.framing.ContentHeaderPropertiesFactory;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.transport.ByteBufferSender;

public class ContentHeaderBody
implements AMQBody {
    public static final byte TYPE = 2;
    public static final int CLASS_ID = 60;
    private static final int HEADER_SIZE = 14;
    private long _bodySize;
    private final BasicContentHeaderProperties _properties;

    public ContentHeaderBody(MarkableDataInput buffer, long size) throws AMQFrameDecodingException, IOException {
        buffer.readUnsignedShort();
        buffer.readUnsignedShort();
        this._bodySize = buffer.readLong();
        int propertyFlags = buffer.readUnsignedShort();
        ContentHeaderPropertiesFactory factory = ContentHeaderPropertiesFactory.getInstance();
        this._properties = factory.createContentHeaderProperties(60, propertyFlags, buffer, (int)size - 14);
    }

    public ContentHeaderBody(BasicContentHeaderProperties props) {
        this._properties = props;
    }

    public ContentHeaderBody(BasicContentHeaderProperties props, long bodySize) {
        this._properties = props;
        this._bodySize = bodySize;
    }

    @Override
    public byte getFrameType() {
        return 2;
    }

    public static ContentHeaderBody createFromBuffer(MarkableDataInput buffer, long size) throws AMQFrameDecodingException, AMQProtocolVersionException, IOException {
        ContentHeaderBody body = new ContentHeaderBody(buffer, size);
        return body;
    }

    @Override
    public int getSize() {
        return 14 + this._properties.getPropertyListSize();
    }

    @Override
    public void writePayload(DataOutput buffer) throws IOException {
        EncodingUtils.writeUnsignedShort(buffer, 60);
        EncodingUtils.writeUnsignedShort(buffer, 0);
        buffer.writeLong(this._bodySize);
        EncodingUtils.writeUnsignedShort(buffer, this._properties.getPropertyFlags());
        this._properties.writePropertyListPayload(buffer);
    }

    @Override
    public long writePayload(ByteBufferSender sender) throws IOException {
        QpidByteBuffer data = QpidByteBuffer.allocateDirect(14);
        EncodingUtils.writeUnsignedShort(data, 60);
        EncodingUtils.writeUnsignedShort(data, 0);
        data.putLong(this._bodySize);
        EncodingUtils.writeUnsignedShort(data, this._properties.getPropertyFlags());
        data.flip();
        sender.send(data);
        data.dispose();
        return 14L + this._properties.writePropertyListPayload(sender);
    }

    public long writePayload(QpidByteBuffer buf) throws IOException {
        EncodingUtils.writeUnsignedShort(buf, 60);
        EncodingUtils.writeUnsignedShort(buf, 0);
        buf.putLong(this._bodySize);
        EncodingUtils.writeUnsignedShort(buf, this._properties.getPropertyFlags());
        return 14L + this._properties.writePropertyListPayload(buf);
    }

    @Override
    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws QpidException {
        session.contentHeaderReceived(channelId, this);
    }

    public static AMQFrame createAMQFrame(int channelId, BasicContentHeaderProperties properties, long bodySize) {
        return new AMQFrame(channelId, new ContentHeaderBody(properties, bodySize));
    }

    public BasicContentHeaderProperties getProperties() {
        return this._properties;
    }

    public String toString() {
        return "ContentHeaderBody{classId=60, weight=0, bodySize=" + this._bodySize + ", properties=" + this._properties + '}';
    }

    public int getClassId() {
        return 60;
    }

    public int getWeight() {
        return 0;
    }

    public long getBodySize() {
        return this._bodySize;
    }

    public void setBodySize(long bodySize) {
        this._bodySize = bodySize;
    }

    public static void process(MarkableDataInput buffer, ChannelMethodProcessor methodProcessor, long size) throws IOException, AMQFrameDecodingException {
        int classId = buffer.readUnsignedShort();
        buffer.readUnsignedShort();
        long bodySize = buffer.readLong();
        int propertyFlags = buffer.readUnsignedShort();
        if (classId != 60) {
            throw new AMQFrameDecodingException(AMQConstant.FRAME_ERROR, "Unsupported content header class id: " + classId, null);
        }
        BasicContentHeaderProperties properties = new BasicContentHeaderProperties();
        properties.populatePropertiesFromBuffer(buffer, propertyFlags, (int)(size - 14L));
        if (!methodProcessor.ignoreAllButCloseOk()) {
            methodProcessor.receiveMessageHeader(properties, bodySize);
        }
    }

    public void dispose() {
        this._properties.dispose();
    }

    public void clearEncodedForm() {
        this._properties.clearEncodedForm();
    }
}

