/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.IOException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.protocol.AMQConstant;

public class ContentHeaderPropertiesFactory {
    private static final ContentHeaderPropertiesFactory _instance = new ContentHeaderPropertiesFactory();

    public static ContentHeaderPropertiesFactory getInstance() {
        return _instance;
    }

    private ContentHeaderPropertiesFactory() {
    }

    public BasicContentHeaderProperties createContentHeaderProperties(int classId, int propertyFlags, MarkableDataInput buffer, int size) throws AMQFrameDecodingException, IOException {
        if (classId != 60) {
            throw new AMQFrameDecodingException(AMQConstant.FRAME_ERROR, "Unsupport content header class id: " + classId, null);
        }
        BasicContentHeaderProperties properties = new BasicContentHeaderProperties();
        properties.populatePropertiesFromBuffer(buffer, propertyFlags, size);
        return properties;
    }
}

