/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.transport.network.Ticker;

public class AggregateTicker
implements Ticker {
    private final CopyOnWriteArrayList<Ticker> _tickers = new CopyOnWriteArrayList();
    private final AtomicBoolean _modified = new AtomicBoolean();

    @Override
    public int getTimeToNextTick(long currentTime) {
        int nextTick = Integer.MAX_VALUE;
        for (Ticker ticker : this._tickers) {
            nextTick = Math.min(ticker.getTimeToNextTick(currentTime), nextTick);
        }
        return nextTick;
    }

    @Override
    public int tick(long currentTime) {
        int nextTick = Integer.MAX_VALUE;
        for (Ticker ticker : this._tickers) {
            nextTick = Math.min(ticker.tick(currentTime), nextTick);
        }
        return nextTick;
    }

    public CopyOnWriteArrayList<Ticker> getTickers() {
        return this._tickers;
    }

    public void addTicker(Ticker ticker) {
        this._tickers.add(ticker);
        this._modified.set(true);
    }

    public void removeTicker(Ticker ticker) {
        this._tickers.remove(ticker);
        this._modified.set(true);
    }

    public boolean getModified() {
        return this._modified.get();
    }

    public void resetModified() {
        this._modified.set(false);
    }
}

