/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.configuration;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import org.apache.qpid.configuration.CommonProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientProperties.class);
    public static final String IGNORE_SET_CLIENTID_PROP_NAME = "ignore_setclientID";
    public static final String MAX_PREFETCH_PROP_NAME = "max_prefetch";
    public static final String MAX_PREFETCH_DEFAULT = "500";
    public static final String SYNC_PERSISTENT_PROP_NAME = "sync_persistence";
    public static final String SYNC_ACK_PROP_NAME = "sync_ack";
    public static final String SYNC_CLIENT_ACK = "sync_client_ack";
    public static final String SYNC_PUBLISH_PROP_NAME = "sync_publish";
    public static final String QPID_HEARTBEAT_INTERVAL = "qpid.heartbeat";
    public static final int QPID_HEARTBEAT_INTERVAL_010_DEFAULT = 120;
    public static final String QPID_HEARTBEAT_TIMEOUT_FACTOR = "qpid.heartbeat_timeout_factor";
    public static final float QPID_HEARTBEAT_TIMEOUT_FACTOR_DEFAULT = 2.0f;
    public static final String DEST_SYNTAX = "qpid.dest_syntax";
    public static final String USE_LEGACY_MAP_MESSAGE_FORMAT = "qpid.use_legacy_map_message";
    public static final String USE_LEGACY_STREAM_MESSAGE_FORMAT = "qpid.use_legacy_stream_message";
    public static final String AMQP_VERSION = "qpid.amqp.version";
    public static final String QPID_VERIFY_CLIENT_ID = "qpid.verify_client_id";
    public static final String QPID_SYNC_OP_TIMEOUT = "qpid.sync_op_timeout";
    public static final int DEFAULT_SYNC_OPERATION_TIMEOUT = 60000;
    public static final String QPID_CLOSE_TIMEOUT = "qpid.close_timeout";
    public static final int DEFAULT_CLOSE_TIMEOUT = 2000;
    public static final String QPID_TCP_NODELAY_PROP_NAME = "qpid.tcp_nodelay";
    public static final String REJECT_BEHAVIOUR_PROP_NAME = "qpid.reject.behaviour";
    public static final String QPID_SSL_KEY_MANAGER_FACTORY_ALGORITHM_PROP_NAME = "qpid.ssl.KeyManagerFactory.algorithm";
    public static final String QPID_SSL_TRUST_MANAGER_FACTORY_ALGORITHM_PROP_NAME = "qpid.ssl.TrustManagerFactory.algorithm";
    public static final String DAEMON_DISPATCHER = "qpid.jms.daemon.dispatcher";
    public static final String PROCESS_NAME = "qpid.client_process";
    public static final String RECEIVE_BUFFER_SIZE_PROP_NAME = "qpid.receive_buffer_size";
    public static final String SEND_BUFFER_SIZE_PROP_NAME = "qpid.send_buffer_size";
    public static final String QPID_FLOW_CONTROL_WAIT_FAILURE = "qpid.flow_control_wait_failure";
    public static final long DEFAULT_FLOW_CONTROL_WAIT_FAILURE = 60000L;
    public static final String QPID_FLOW_CONTROL_WAIT_NOTIFY_PERIOD = "qpid.flow_control_wait_notify_period";
    public static final long DEFAULT_FLOW_CONTROL_WAIT_NOTIFY_PERIOD = 5000L;
    public static final String QPID_DECLARE_QUEUES_PROP_NAME = "qpid.declare_queues";
    public static final String QPID_DECLARE_EXCHANGES_PROP_NAME = "qpid.declare_exchanges";
    public static final String QPID_BIND_QUEUES_PROP_NAME = "qpid.bind_queues";
    public static final String VERIFY_QUEUE_ON_SEND = "qpid.verify_queue_on_send";
    public static final String QPID_MAX_CACHED_ADDR_OPTION_STRINGS = "qpid.max_cached_address_option_strings";
    public static final int DEFAULT_MAX_CACHED_ADDR_OPTION_STRINGS = 10;
    public static final String SET_EXPIRATION_AS_TTL = "qpid.set_expiration_as_ttl";
    public static final String CONNECTION_OPTION_SSL_VERIFY_HOST_NAME = "qpid.connection_ssl_verify_hostname";
    public static final boolean DEFAULT_CONNECTION_OPTION_SSL_VERIFY_HOST_NAME = true;
    public static final String CONNECTION_OPTION_COMPRESS_MESSAGES = "qpid.connection_compress_messages";
    public static final boolean DEFAULT_CONNECTION_OPTION_COMPRESS_MESSAGES = false;
    public static final String CONNECTION_OPTION_MESSAGE_COMPRESSION_THRESHOLD_SIZE = "qpid.message_compression_threshold_size";
    public static final int DEFAULT_MESSAGE_COMPRESSION_THRESHOLD_SIZE = 102400;
    public static final String ADDR_SYNTAX_SUPPORTED_IN_0_8 = "qpid.addr_syntax_supported";
    public static final boolean DEFAULT_ADDR_SYNTAX_0_8_SUPPORT = true;
    public static final String QPID_USE_LEGACY_GETQUEUEDEPTH_BEHAVIOUR = "qpid.use_legacy_getqueuedepth_behavior";
    private static volatile boolean _loaded;

    public static synchronized void ensureIsLoaded() {
        if (!_loaded) {
            CommonProperties.ensureIsLoaded();
            Properties props = new Properties();
            String initialProperties = System.getProperty("qpid.client_properties_file");
            URL initialPropertiesLocation = null;
            try {
                initialPropertiesLocation = initialProperties == null ? ClientProperties.class.getClassLoader().getResource("qpid-client.properties") : new File(initialProperties).toURI().toURL();
                if (initialPropertiesLocation != null) {
                    props.load(initialPropertiesLocation.openStream());
                }
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Could not open client properties file '" + initialProperties + "'.", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.warn("Could not open client properties file '" + initialPropertiesLocation + "'.", (Throwable)e);
            }
            HashSet<String> propertyNames = new HashSet<String>(props.stringPropertyNames());
            propertyNames.removeAll(System.getProperties().stringPropertyNames());
            for (String propName : propertyNames) {
                System.setProperty(propName, props.getProperty(propName));
            }
            _loaded = true;
        }
    }

    private ClientProperties() {
    }

    static {
        ClientProperties.ensureIsLoaded();
    }
}

