/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.transport.ByteBufferSender;

public class AMQFrame
extends AMQDataBlock
implements EncodableAMQDataBlock {
    private static final int HEADER_SIZE = 7;
    private final int _channel;
    private final AMQBody _bodyFrame;
    public static final byte FRAME_END_BYTE = -50;
    private static final QpidByteBuffer FRAME_END_BYTE_BUFFER = QpidByteBuffer.allocateDirect(1);

    public AMQFrame(int channel, AMQBody bodyFrame) {
        this._channel = channel;
        this._bodyFrame = bodyFrame;
    }

    @Override
    public long getSize() {
        return 7 + this._bodyFrame.getSize() + 1;
    }

    public static final int getFrameOverhead() {
        return 8;
    }

    @Override
    public long writePayload(ByteBufferSender sender) {
        QpidByteBuffer frameHeader = QpidByteBuffer.allocate(sender.isDirectBufferPreferred(), 7);
        frameHeader.put(this._bodyFrame.getFrameType());
        frameHeader.putUnsignedShort(this._channel);
        frameHeader.putUnsignedInt(this._bodyFrame.getSize());
        frameHeader.flip();
        sender.send(frameHeader);
        frameHeader.dispose();
        long size = 8L + this._bodyFrame.writePayload(sender);
        sender.send(FRAME_END_BYTE_BUFFER.duplicate());
        return size;
    }

    public final int getChannel() {
        return this._channel;
    }

    public final AMQBody getBodyFrame() {
        return this._bodyFrame;
    }

    public String toString() {
        return "Frame channelId: " + this._channel + ", bodyFrame: " + String.valueOf(this._bodyFrame);
    }

    static {
        FRAME_END_BYTE_BUFFER.put((byte)-50);
        FRAME_END_BYTE_BUFFER.flip();
    }
}

