/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.ChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;

public class BasicNackBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 120;
    private final long _deliveryTag;
    private final byte _bitfield0;

    public BasicNackBody(long deliveryTag, boolean multiple, boolean requeue) {
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (multiple) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (requeue) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 120;
    }

    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    public final boolean getMultiple() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getRequeue() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 9;
        return size;
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicNack(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicNackBodyImpl: ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("multiple=");
        buf.append(this.getMultiple());
        buf.append(", ");
        buf.append("requeue=");
        buf.append(this.getRequeue());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ChannelMethodProcessor dispatcher) {
        boolean requeue;
        long deliveryTag = buffer.getLong();
        byte bitfield = buffer.get();
        boolean multiple = (bitfield & 1) != 0;
        boolean bl = requeue = (bitfield & 2) != 0;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicNack(deliveryTag, multiple, requeue);
        }
    }
}

