/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;

public class ExchangeBoundBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 40;
    public static final int METHOD_ID = 22;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final AMQShortString _queue;

    public ExchangeBoundBody(AMQShortString exchange, AMQShortString routingKey, AMQShortString queue) {
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._queue = queue;
    }

    @Override
    public int getClazz() {
        return 40;
    }

    @Override
    public int getMethod() {
        return 22;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._routingKey);
        return size += this.getSizeOf(this._queue);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeAMQShortString(buffer, this._queue);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchExchangeBound(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ExchangeBoundBodyImpl: ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ServerChannelMethodProcessor dispatcher) {
        AMQShortString exchange = AMQShortString.readAMQShortString(buffer);
        AMQShortString routingKey = AMQShortString.readAMQShortString(buffer);
        AMQShortString queue = AMQShortString.readAMQShortString(buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveExchangeBound(exchange, routingKey, queue);
        }
    }
}

