/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQProtocolClassException;
import org.apache.qpid.framing.AMQProtocolHeaderException;
import org.apache.qpid.framing.AMQProtocolInstanceException;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.transport.ByteBufferSender;

public class ProtocolInitiation
extends AMQDataBlock
implements EncodableAMQDataBlock {
    private static final byte[] AMQP_HEADER = new byte[]{65, 77, 81, 80};
    private static final byte CURRENT_PROTOCOL_CLASS = 1;
    private static final byte TCP_PROTOCOL_INSTANCE = 1;
    private final byte[] _protocolHeader;
    private final byte _protocolClass;
    private final byte _protocolInstance;
    private final byte _protocolMajor;
    private final byte _protocolMinor;

    public ProtocolInitiation(byte[] protocolHeader, byte protocolClass, byte protocolInstance, byte protocolMajor, byte protocolMinor) {
        this._protocolHeader = protocolHeader;
        this._protocolClass = protocolClass;
        this._protocolInstance = protocolInstance;
        this._protocolMajor = protocolMajor;
        this._protocolMinor = protocolMinor;
    }

    public ProtocolInitiation(ProtocolVersion pv) {
        this(AMQP_HEADER, pv.equals(ProtocolVersion.v0_91) ? (byte)0 : 1, pv.equals(ProtocolVersion.v0_91) ? (byte)0 : 1, pv.equals(ProtocolVersion.v0_91) ? (byte)9 : (byte)pv.getMajorVersion(), pv.equals(ProtocolVersion.v0_91) ? (byte)1 : pv.getMinorVersion());
    }

    public ProtocolInitiation(QpidByteBuffer in) {
        this._protocolHeader = new byte[4];
        in.get(this._protocolHeader);
        this._protocolClass = in.get();
        this._protocolInstance = in.get();
        this._protocolMajor = in.get();
        this._protocolMinor = in.get();
    }

    @Override
    public long getSize() {
        return 8L;
    }

    @Override
    public long writePayload(ByteBufferSender sender) {
        byte[] data = new byte[8];
        for (int i = 0; i < this._protocolHeader.length; ++i) {
            data[i] = this._protocolHeader[i];
        }
        data[4] = this._protocolClass;
        data[5] = this._protocolInstance;
        data[6] = this._protocolMajor;
        data[7] = this._protocolMinor;
        sender.send(QpidByteBuffer.wrap(data));
        return 8L;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProtocolInitiation)) {
            return false;
        }
        ProtocolInitiation pi = (ProtocolInitiation)o;
        if (pi._protocolHeader == null) {
            return false;
        }
        if (this._protocolHeader.length != pi._protocolHeader.length) {
            return false;
        }
        for (int i = 0; i < this._protocolHeader.length; ++i) {
            if (this._protocolHeader[i] == pi._protocolHeader[i]) continue;
            return false;
        }
        return this._protocolClass == pi._protocolClass && this._protocolInstance == pi._protocolInstance && this._protocolMajor == pi._protocolMajor && this._protocolMinor == pi._protocolMinor;
    }

    public int hashCode() {
        int result = this._protocolHeader != null ? Arrays.hashCode(this._protocolHeader) : 0;
        result = 31 * result + this._protocolClass;
        result = 31 * result + this._protocolInstance;
        result = 31 * result + this._protocolMajor;
        result = 31 * result + this._protocolMinor;
        return result;
    }

    public ProtocolVersion checkVersion() throws QpidException {
        ProtocolVersion pv;
        if (this._protocolHeader.length != 4) {
            throw new AMQProtocolHeaderException("Protocol header should have exactly four octets", null);
        }
        for (int i = 0; i < 4; ++i) {
            if (this._protocolHeader[i] == AMQP_HEADER[i]) continue;
            try {
                throw new AMQProtocolHeaderException("Protocol header is not correct: Got " + new String(this._protocolHeader, "ISO-8859-1") + " should be: " + new String(AMQP_HEADER, "ISO-8859-1"), null);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (this._protocolInstance == 0 && this._protocolMajor == 9 && this._protocolMinor == 1) {
            pv = ProtocolVersion.v0_91;
            if (this._protocolClass != 0) {
                throw new AMQProtocolClassException("Protocol class 0 was expected; received " + this._protocolClass, null);
            }
        } else {
            if (this._protocolClass != 1) {
                throw new AMQProtocolClassException("Protocol class 1 was expected; received " + this._protocolClass, null);
            }
            if (this._protocolInstance != 1) {
                throw new AMQProtocolInstanceException("Protocol instance 1 was expected; received " + this._protocolInstance, null);
            }
            pv = ProtocolVersion.get(this._protocolMajor, this._protocolMinor);
        }
        if (!pv.isSupported()) {
            throw new AMQProtocolVersionException("Protocol version " + this._protocolMajor + "." + this._protocolMinor + " not supported.", null);
        }
        return pv;
    }

    public byte getProtocolClass() {
        return this._protocolClass;
    }

    public byte getProtocolInstance() {
        return this._protocolInstance;
    }

    public byte getProtocolMajor() {
        return this._protocolMajor;
    }

    public byte getProtocolMinor() {
        return this._protocolMinor;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(new String(this._protocolHeader, StandardCharsets.US_ASCII));
        buffer.append(Integer.toHexString(this._protocolClass));
        buffer.append(Integer.toHexString(this._protocolInstance));
        buffer.append(Integer.toHexString(this._protocolMajor));
        buffer.append(Integer.toHexString(this._protocolMinor));
        return buffer.toString();
    }

    public static class Decoder {
        public int decodable(QpidByteBuffer in) {
            return in.remaining() >= 8 ? 0 : 8 - in.remaining();
        }
    }
}

